﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {

        [DllImport("user32.dll", SetLastError = true)]
        static extern IntPtr FindWindowEx(IntPtr hwndParent, IntPtr hwndChildAfter, string lpszClass, string lpszWindow);
        
        [DllImport("user32.dll")]
        private static extern IntPtr SendMessage(IntPtr hWnd, int Msg, IntPtr wParam, IntPtr lParam);

        private int WM_SETTEXT = 0x000c;
        private int WM_CLOSE = 0x0010;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Process [] processes = Process.GetProcessesByName("notepad");
            if (processes.Length > 0)
            //    MessageBox.Show("Znalazłem " + processes.Length + " procesów");
            {
                string tekst = textBox1.Text;
                IntPtr x = Marshal.StringToHGlobalAnsi(tekst);

                for (int i = 0; i < processes.Length; i++)
                {
                    IntPtr hEdit = FindWindowEx(processes[i].MainWindowHandle, IntPtr.Zero,
                        "Edit", "");
                    
                    SendMessage(hEdit, WM_SETTEXT, IntPtr.Zero, x);
            
                }

                Marshal.FreeHGlobal(x);
            }
            else
                MessageBox.Show("Nie znaleziono żadnego procesu notatnika.\nUruchom najpierw \"notepad.exe\"");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Process[] processes = Process.GetProcessesByName(textBox2.Text);
            if (processes.Length > 0)
            //    MessageBox.Show("Znalazłem " + processes.Length + " procesów");
            {
                for (int i = 0; i < processes.Length; i++)
                {
                    SendMessage(processes[i].MainWindowHandle, WM_CLOSE, IntPtr.Zero, IntPtr.Zero);
                }
            }
            else
                MessageBox.Show("Nie znalazłem procesów " + textBox2.Text);
        }

        protected override void WndProc(ref Message m)
        {

            if (checkBox1.Checked)
            {
                listBox1.Items.Add(m.ToString());
            }
            
            base.WndProc(ref m);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }

        private void groupBox1_Enter(object sender, EventArgs e)
        {

        }

        private void button4_Click(object sender, EventArgs e)
        {
            string text = textBox2.Text;
            if (Process.Start(text) == null)
                MessageBox.Show("Błąd! Nie uruchomiono procesu: " + text);
        }
    }
}
