﻿using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace pinvoke
{

    public delegate bool CallBackPtr(IntPtr hwnd, int lParam);

    public class EnumReport
    {
        [DllImport("user32.dll")]
        public static extern int EnumWindows(CallBackPtr callPtr, int lPar);

        [DllImport("user32.dll")]
        private static extern int GetWindowTextLength(IntPtr hwnd);

        [DllImport("user32.dll")]
        private static extern int GetWindowText(IntPtr hwnd, StringBuilder text, int size);

        public static bool Report(IntPtr hwnd, int lParam)
        {
            Console.WriteLine("Window handle is " + hwnd);
            int n = GetWindowTextLength(hwnd);
            StringBuilder napis = new StringBuilder(n + 1);
            if (n > 0)
            {
                GetWindowText(hwnd, napis, napis.Capacity);
                Console.WriteLine("   Title: " + napis.ToString());
            }
            return true;
        }
    }


    class Program
    {
        
        [DllImport("biblioteka.dll", CharSet=CharSet.Auto, CallingConvention = CallingConvention.Cdecl)]
        static extern void Komunikat(String napis);

        [DllImport("kernel32.dll", SetLastError = true, CharSet = CharSet.Auto)]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool GetDiskFreeSpaceEx(string lpDirectoryName,
            out ulong lpFreeBytesAvailable,
            out ulong lpTotalNumberOfBytes,
            out ulong lpTotalNumberOfFreeBytes);

   
        [DllImport("user32.dll")]
        public static extern IntPtr FindWindowEx(IntPtr hwndParent, IntPtr hwndChildAfter, string lpszClass, string lpszWindow);

        [DllImport("User32.dll")]
        public static extern int SendMessage(IntPtr hWnd, int uMsg, int wParam, string lParam);
        
        static void Main(string[] args)
        {
            Console.WriteLine("Hello world");
            Komunikat("Witaj świecie WinAPI");
            
            ulong FreeBytesAvailable;
            ulong TotalNumberOfBytes;
            ulong TotalNumberOfFreeBytes;
            
            bool success = GetDiskFreeSpaceEx("C:\\", out FreeBytesAvailable, out TotalNumberOfBytes,
                               out TotalNumberOfFreeBytes);
            if (!success)
                throw new System.ComponentModel.Win32Exception();

            Console.WriteLine("Free Bytes Available:      {0,15:D}", FreeBytesAvailable);
            Console.WriteLine("Total Number Of Bytes:     {0,15:D}", TotalNumberOfBytes);
            Console.WriteLine("Total Number Of FreeBytes: {0,15:D}", TotalNumberOfFreeBytes);

            // note in other situations, it is important to keep 
            // callBackPtr as a member variable so it doesnt GC while you're calling EnumWindows

            CallBackPtr callBackPtr = new CallBackPtr(EnumReport.Report);
            EnumReport.EnumWindows(callBackPtr, 0);

        
            int WM_SETTEXT = 0x000c;

            Process[] notepads = Process.GetProcessesByName("notepad");
            if (notepads.Length == 0) return;
            if (notepads[0] != null)
            {
                IntPtr child = FindWindowEx(notepads[0].MainWindowHandle, new IntPtr(0), "Edit", null);
                SendMessage(child, WM_SETTEXT, 0, "Witaj świecie!");
            }
        }
    }
}
