// paint.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "paint.h"
#include <Commdlg.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int xPrev, yPrev;


int APIENTRY _tWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPTSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_PAINT, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_PAINT));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_PAINT));
	wcex.hCursor		= LoadCursor(hInstance, MAKEINTRESOURCE(IDC_CURSOR1));
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_PAINT);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL czy_rysowac = FALSE;
	static POINT ptPrevious;
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	static HPEN hPen;
	static int nPenStyle = PS_SOLID; 
	static int nPenSize = 1;
	static COLORREF cPenColor RGB(0, 0, 0);

	switch (message)
	{
	case WM_CREATE:
		hPen = CreatePen(nPenStyle, nPenSize, cPenColor);

	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case ID_TOOLS_PENCOLOR: 
			{
				CHOOSECOLOR cc;                 // common dialog box structure 
				static COLORREF acrCustClr[16]; // array of custom colors 

				// Initialize CHOOSECOLOR 
				ZeroMemory(&cc, sizeof(cc));
				cc.lStructSize = sizeof(cc);
				cc.hwndOwner = hWnd;
				cc.lpCustColors = (LPDWORD)acrCustClr;
				cc.rgbResult = cPenColor;
				cc.Flags = CC_FULLOPEN | CC_RGBINIT;

				if (ChooseColor(&cc) == TRUE) cPenColor = cc.rgbResult;
			}
			break;
		case ID_PENSTYLE_SOLID: nPenStyle = PS_SOLID; break;
		case ID_PENSTYLE_DASH: nPenStyle = PS_DASH; break;
		case ID_PENSTYLE_DOT: nPenStyle = PS_DOT; break;
		case ID_PENSIZE_1: nPenSize = 1; break;
		case ID_PENSIZE_3: nPenSize = 3; break;
		case ID_PENSIZE_5: nPenSize = 5; break;
		case ID_PENSIZE_10: nPenSize = 10; break;
		case ID_PENSIZE_15: nPenSize = 15; break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_LBUTTONDOWN: 
		czy_rysowac = TRUE; 
		xPrev = LOWORD(lParam); 
		yPrev = HIWORD(lParam); 
		
		DeleteObject(hPen);
		hPen = CreatePen(nPenStyle, nPenSize, cPenColor);

		return 0L; 
 
	case WM_LBUTTONUP: 
  	  czy_rysowac = FALSE; 
	  break;;

	case WM_MOUSEMOVE: 
		if (czy_rysowac) 
		{ 
			hdc = GetDC(hWnd); 

			int xPos = LOWORD(lParam);
			int yPos = HIWORD(lParam);

			SelectObject(hdc, hPen);
        
			MoveToEx(hdc, xPrev, yPrev, NULL); 
			LineTo(hdc, xPos, yPos); 
			xPrev = xPos;
			yPrev = yPos;

			ReleaseDC(hWnd, hdc); 
		} 
		break;
	case WM_PAINT:
	{
		HPEN pen, oldPen;
		HBRUSH brush, oldBrush;
		HFONT font, oldFont;

		hdc = BeginPaint(hWnd, &ps);
		
		// Domonstracja kilku narzedzi do rysowania

		pen = CreatePen(PS_DOT, 1, RGB(255, 0, 0));
		brush = CreateHatchBrush(HS_CROSS, RGB(0,255, 0 ));
		font = CreateFont(36,20,-300,0,FW_DONTCARE,FALSE,TRUE,FALSE,DEFAULT_CHARSET,OUT_OUTLINE_PRECIS,
                CLIP_DEFAULT_PRECIS,CLEARTYPE_QUALITY, VARIABLE_PITCH,TEXT("Times New Roman"));
		
		oldPen = (HPEN)SelectObject(hdc, pen);
		oldBrush = (HBRUSH)SelectObject(hdc, brush);
		oldFont = (HFONT)SelectObject(hdc, font);

		Ellipse(hdc, 0, 0, 200, 400);

		MoveToEx(hdc, 20, 30, NULL);
		LineTo(hdc, 100, 200);

		DeleteObject(pen);
		pen = CreatePen(PS_SOLID, 10, RGB(0, 0, 255));
		oldPen = (HPEN)SelectObject(hdc, pen);

		LineTo(hdc, 200, 250);


		for (int i = 0; i < 200; i++)
			for (int j = 0; j < 200; j++)
				SetPixel(hdc, 300 +i, 20 + j, RGB(255 - (int)((i+j) * (255/400.0)), j, i));
		
		TextOut(hdc, 100, 100, TEXT("Hello world"),11);

		Pie(hdc, 400, 400, 500, 500, 470, 430, 470, 470);

		SelectObject(hdc, oldPen);
		SelectObject(hdc, oldBrush);
		SelectObject(hdc, oldFont);
		DeleteObject(pen);
		DeleteObject(brush);
		DeleteObject(font);
		EndPaint(hWnd, &ps);
	}
	break;
	case WM_DESTROY:
		DeleteObject(hPen);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
