// invaders.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "invaders.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPTSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_INVADERS, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_INVADERS));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_INVADERS));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_INVADERS);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

void RysujUfo1(HDC hdc, HDC hdcBmp, int x, int y, int frame)
{
	if(frame %2)
		BitBlt(hdc, x, y, 64, 64 , hdcBmp, 40, 30, SRCCOPY);
	else
		BitBlt(hdc, x, y, 64, 64 , hdcBmp, 142, 30, SRCCOPY);

}

void RysujUfo2(HDC hdc, HDC hdcBmp, int x, int y, int frame)
{
	if (frame % 2)
		BitBlt(hdc, x, y, 89, 64, hdcBmp, 26, 130, SRCCOPY);
	else
		BitBlt(hdc, x, y, 89, 64, hdcBmp, 131, 134, SRCCOPY);

}

void RysujUfo3(HDC hdc, HDC hdcBmp, int x, int y, int frame)
{
	if (frame % 2)
		BitBlt(hdc, x, y, 97, 65, hdcBmp, 13, 241, SRCCOPY);
	else
		BitBlt(hdc, x, y, 97, 65, hdcBmp, 128, 242, SRCCOPY);

}
//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
#define ID_TIMER1 1
float szybkosc = 2.0;

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	static HBITMAP hbmp, oldBmp;
	static HDC hdcBmp;

	switch (message)
	{
	case WM_CREATE:
		{
			hbmp = LoadBitmap(GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP1));
			if (hbmp == NULL) MessageBox(hWnd, TEXT("Blad czytania bitmapy"), TEXT(""), MB_OK);
		
			HDC hdc = GetDC(hWnd);
			hdcBmp = CreateCompatibleDC(hdc);
			oldBmp = (HBITMAP)SelectObject(hdcBmp, hbmp);
			ReleaseDC(hWnd, hdc);

			SetTimer(hWnd, ID_TIMER1, 10, NULL);
			}

		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_TIMER:
		{
			static int time =0 ; 
			static int ufo1_x = 10, ufo1_y = 10;
			static int ufo2_x = 10, ufo2_y = 100;
			static int ufo3_x = 10, ufo3_y = 200;
			static float ufo1_dx = 1;
			static float ufo2_dx = 1;
			static float ufo3_dx = 1;

			ufo1_x += ufo1_dx * szybkosc;
			ufo2_x += 2 * ufo2_dx * szybkosc;
			ufo3_x += 3 * ufo3_dx * szybkosc;

			RECT rc;
			GetClientRect(hWnd, &rc);
			
			if (ufo1_x > rc.right - 100 || ufo1_x < 10) ufo1_dx *= -1;
			if (ufo2_x > rc.right - 100 || ufo2_x < 10) ufo2_dx *= -1;
			if (ufo3_x > rc.right - 100 || ufo3_x < 10) ufo3_dx *= -1;

			HDC hdc = GetDC(hWnd);
			FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));

			RysujUfo1(hdc, hdcBmp, ufo1_x, ufo1_y, time / 10);
			RysujUfo2(hdc, hdcBmp, ufo2_x, ufo2_y, time / 10);
			RysujUfo3(hdc, hdcBmp, ufo3_x, ufo3_y, time / 10);

			ReleaseDC(hWnd, hdc);
			time ++;
		}

		break;
	case WM_PAINT:
		{
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Add any drawing code here...
	/*			
		BITMAP bmp;
		
		RECT rc;
		GetClientRect(hWnd, &rc);
		FillRect(hdc, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH)); 
		GetObject(hbmp, sizeof(bmp), &bmp);

		BitBlt(hdc, 0, 0, bmp.bmWidth, bmp.bmHeight, hdcBmp, 0, 0, SRCCOPY);

		EndPaint(hWnd, &ps);
	*/	
	}
		break;
	case WM_KEYDOWN:
		if(wParam == VK_UP)
			szybkosc += 1;
		if(wParam == VK_DOWN)
			szybkosc *= 0.9;

		break;
	case WM_DESTROY:

		SelectObject(hdcBmp, oldBmp);
		DeleteObject(hbmp);
		ReleaseDC(hWnd, hdcBmp);

		KillTimer(hWnd, ID_TIMER1);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
