#include <windows.h>

// Statyczne linkowanie biblioteki

#include "..\\biblioteka\\dll.h"
#pragma comment(lib, "..\\Debug\\biblioteka.lib")

#define IDC_BUTTON 1
#define IDC_BUTTON2 2

int f(LPVOID *d)
{
	// Funkcja wykonuje sie przez 3 sekundy w osobnym watku
	Sleep(3000);
	return 0;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
switch(msg)
    {
		case WM_CREATE:
			CreateWindow(TEXT("BUTTON"), TEXT("Uruchom funkcj z biblioteki"),
				WS_CHILD | WS_VISIBLE, 10, 10, 300, 30, 
				hwnd, (HMENU)IDC_BUTTON, GetModuleHandle(NULL),NULL);
			CreateWindow(TEXT("BUTTON"), TEXT("Uruchom dodatkowy wtek"),
				WS_CHILD | WS_VISIBLE, 10, 50, 300, 30,
				hwnd, (HMENU)IDC_BUTTON2, GetModuleHandle(NULL), NULL);
			break;
		case WM_COMMAND:
			if(LOWORD(wParam) == IDC_BUTTON)
			{
				Komunikat(TEXT("Witaj wiecie!!"));
			}
			break;
        case WM_CLOSE:
            DestroyWindow(hwnd);
        break;
        case WM_DESTROY:
            PostQuitMessage(0);
        break;
        default:
            return DefWindowProc(hwnd, msg, wParam, lParam);
    }
    return 0;
}


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASSEX wc;
	HWND hwnd;
	MSG Msg;

	ZeroMemory(&wc, sizeof(wc));
	wc.cbSize = sizeof(wc);
	wc.lpszClassName = TEXT("Klasa okien");
	wc.hInstance = hInstance;
	wc.lpfnWndProc = WndProc;
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hIconSm = LoadIcon(NULL, IDI_APPLICATION);

	if (!RegisterClassEx(&wc))
	{
		MessageBox(NULL, TEXT("Blad rejestrowania klasy okna"), TEXT("Blad"), 
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}

	hwnd = CreateWindow(TEXT("Klasa okien"), TEXT("Witaj swiecie"), WS_OVERLAPPEDWINDOW, 10, 10, 500, 600, 
		NULL, NULL, hInstance, NULL);

	if (hwnd == NULL)
	{
		MessageBox(NULL, TEXT("Blad tworzenia okna!"), TEXT("Blad"),
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
    {
        TranslateMessage(&Msg);
        DispatchMessage(&Msg);
    }

	return Msg.wParam;
}
