function [q dw dt labels]=uqpc_function(x,w,p,func)
% Unsupervised QPC version 1 
% Rni sie od QPCproto tylko tym, e przeetykowujemy dane w zalenoci od
% pooenia prototypw.
% Uwaga : prototypy bez etykiet (tylko polozenie, kazdy prototyp
% reprezentuje osobny klaster).
% q - wartosc funkcji
% dw - gradient po wagach
% dt - gradient po pozycji prototypow

ninit = size(w,1);

if  nargin < 4 || isempty(func); func=@(x)f_gauss(x,0.1); end
% TODO: automatyczny dobor szerokosci funkcji 

%if nargin < 3; p = []; end
if nargin < 3; error('To few parameters'); end

ver=2;
% 1 - etykietowanie wzgl. pozycji w R^n (przed projekcja x)
% 2 - etykietowane wzgl. pozycji w R^1 (po projekcji wx)

[vectorsCount featuresCount] = size(x);
projection = x*w';

% if isempty(p)
%     tw = projection;
%     np = vectorsCount;
% else
%     tw = p(:,1:end-1)*w';
%     np = size(p,1);
% end


tw=p(:,1:end-1)*w';

G = zeros(ninit,vectorsCount);
protoCount = size(p,1);
A = zeros(1,protoCount);
distance=@(x1,x2)dEuclid(x1,x2);

if nargout > 1
    dw =zeros(ninit,featuresCount);
    if nargin > 2
        if ninit == 1
            dt=zeros(protoCount,featuresCount);
        else
            dt=zeros(protoCount,ninit,featuresCount);
        end
    end
end

%%%% Data labeling acording to distance from nearest prototype
labels=zeros(vectorsCount,1);
for i=1:vectorsCount
    if ver == 1
        xx = ones(protoCount,1)*x(i,:);
        [~, labels(i)]=min(distance(p,xx),[],1);
    else
        xx = ones(protoCount,1)*projection(i);
        [~, labels(i)]=min(distance(tw,xx),[],1);
    end
end

% bgraph(projection,labels);

for i=1:protoCount
    ii = labels == i;
    lc = nnz(ii);
 
    A(ii) = 1/lc;
    A(~ii)=-1/(vectorsCount-lc);

    if nargout == 1
        f  = func(projection - tw(i.*ones(vectorsCount,1),:));
    else
        [f df] = func(projection - tw(i.*ones(vectorsCount,1),:));
    end

    G(:,i) = A*f; 
     if nargout > 1
         xd = x - p(i.*ones(vectorsCount,1),1:end-1);
         dw = dw + df'.*A(ones(ninit,1),:)*xd;
     end
     if nargout > 2
         if ninit == 1
             dt(i,:)=(A*df)*w;
         else
           tmp=(A*df)';
           dt(i,:,:) = tmp(:,ones(1,featuresCount)).*w;
         end
     end
end
q = sum(G,2)./protoCount;

if nargout > 1
    dw =dw./protoCount;
end
