function [pval t H]=ttest_corrected(x1,x2,fraction,alpha)

%  X1, X2 - paired sample
% fraction= n1/n2, n1 = number of instances used for testing, n2 = numbet of instances used for training
% For 10x10 CV fraction=1/9
% alpha - significance level (0.05 default)
% note that for fraction=0 this test is eqivalent to ttest

if nargin < 3; fraction = 0; end
if nargin < 4; alpha = 0.05; end

xd=x1-x2;
n=length(x1);
mx=mean(xd);
sd=var(xd);
if sd == 0 
    t = 0;
else
    t= mx/sqrt(sd*(1/n - fraction));
end

pval=tcdf(-abs(t),n-1)*2;

qt = tinv(1-alpha/2,n-1);

if abs(t) > qt
    H = 1;
else
    H = 0;
end
