function [acc std1 results]=cv(x,y,models,folds,repetitions,logfile)
% function [acc std accinfo]=CV(X,Y,MODEL,FOLDS,REPETITIONS)
% ACC=CV(X,Y,MODEL) perform CV test on given data X with labels Y using given
% MODEL
%
%   note that train data in each fold are normalized before lraning
%
%    CV(X,Y,MODEL,FOLDS) sets number of crossvalidation FOLDS (default 10)
%    CV(X,Y,FOLDS,REPETITIONS) sets number of REPEROTIONS of CV test
%    (default 1)
%
%   Posible outputs are:
%   [ACC STD INFO]=CV(X,Y,MODEL)
%    
%   ACC average accuracy
%   STD average standard deviation of accuracy
%   INFO - struct contigning detiled info for each fold
%   INFO.acc  - table REPETITIONS X FOLDS of accuracies
%   INFO.avg_acc - avg. accuracy
%   INFO.acc_std - std. of acc
%   INFL.cv_type = 'stratified'  
%   INFO.model - trained model (or INFO.model.object class object) 
%
% 
%  trainmodel=model.train(x,y)
%  acc = model.test(x,trainmodel);
% 
%   CV(X,Y,FOLDS,REPETITIONS,MODEL) sets MODEL for testing, MODEL must be
%    a function handle of form @(X,Y)MODEL(X,Y) (default PPINETWORK is used with default parameters)

if nargin < 6 ; logfile = []; end
if nargin < 5 ; repetitions = 1; end
if nargin < 4; folds = 10; end
if nargin < 3; error('Please speciffy a MODEL and dataset X with labels Y'); end

log = ~isempty(logfile);

traintransform=@(x)normalize(x);
testtransform=@(x,a)normalize(x,a);
%results=struct([]);
NModels = length(models);

r.NFolds = folds;
r.NRepetitions = repetitions;

r.avg_acc = [];
r.acc_std = [];
r.acc = zeros(folds,repetitions);
r.ttest = zeros(1,NModels);
%r.model = 
%results.model = struct([]);
%results.repetition = zeros(1;folds,repetitions);
%results.fold = zeros(folds,repetitions);
r.cv_type = 'stratified';



acc = zeros(1,NModels);
std1 = zeros(1,NModels); 

for m=1:NModels
    results(m) = struct(r);
end    

cvpart = cvpartition(y,'k',folds);

if log
    flog=fopen(logfile,'w');
    fprintf(flog,'CV %dx%d test [%s]\n',folds,repetitions,datestr(now,'yy.mm.dd-HH:MM'));
    fprintf(flog,'Models:');
    for m=1:NModels
             fprintf(flog,' %s',models(m).info);
    end
end

for n=1:repetitions
    %indices = crossvalind('Kfold',y,folds);
    cvpart = cvpart.repartition();
    for i=1:folds
%        disp(find(cvpart.test(i)'));
        
        fprintf('\nCV Test %d fold %d\n',n,i);
        if log ; fprintf(flog,'\nAcc [%2dx%2d]:',n,i); end
         [traindata a]=traintransform(x(cvpart.training(i),:));
         testdata=testtransform(x(cvpart.test(i),:),a);
        
         %results.model(i,n) = model.train(traindata,y(cvpart.training(i)));
        for m=1:NModels
             fprintf('Model: %s\n',models(m).info);
             tic;
             net = models(m).train(traindata,y(cvpart.training(i)));
          
             if isobject(net)
                 results(m).model(i,n).info=class(net);
                 results(m).model(i,n).object=net;
             else
                 results(m).model(i,n)=net;
             end
             results(m).acc(i,n) = models(m).test(testdata,y(cvpart.test(i)),net);
             results(m).time(i,n) = toc;

             fprintf('Accuracy: %.2f %%\nTime: %.2f s.\n',results(m).acc(i,n),results(m).time(i,n));
             if log ; fprintf(flog,' %.2f',results(m).acc(i,n)); end
        end
   end
end

for m=1:NModels
    results(m).avg_acc = mean(results(m).acc(:));
    results(m).acc_std = std(results(m).acc(:));
    results(m).avg_time = mean(results(m).time(:));
    results(m).avg_time_std = std(results(m).time(:));
    acc(m) = results(m).avg_acc;
    std1(m) = results(m).acc_std;
    for m2=1:NModels
        results(m).ttest(m2) = ttest_corrected(results(m).acc(:),results(m2).acc(:),1/(folds-1));
    end
end    
 
if log
    fprintf(flog,'\nAverage : Model Accuracy Time\n');
    for m=1:NModels
        fprintf(flog,'%s %6.2f %6.2f %6.2f %6.2f\n',models(m).info,results(m).avg_acc,results(m).acc_std,results(m).avg_time,results(m).avg_time_std);
    end
end    

    fclose(flog);
end


% return;
