#!/bin/tcsh

if ( $#argv == 0 ) then
	goto usage
endif
if ( $argv[1] == "-h" ) then
	goto usage
endif

foreach logfile ( $argv )
	set bi = `awk '/was the best/{print $2}' $logfile`
	set dir = `dirname $logfile`
   set prefix = `dirname $logfile`/`basename $logfile .log`-$bi
	if ( -e $prefix.last.png ) then
		mv $prefix.last.png $prefix.best.png
		echo $prefix.last.png '->' $prefix.best.png
	else if ( -e $prefix.best.png ) then
		echo Plik $prefix.best.png juz istnieje
	else
		echo Blad! w pliku $logfile
	endif
end

exit 0

usage:
	echo -n 'Skrypt zmienia nazwy plikow .png stanowiacych wynik'
	echo -n 'testow PPI z (wyszukuje najlepsze ze wszystkich inicjalizacji)\n'
	echo '    dataset-parametry-N.last.png -> dataset-parametry-N.best.png'
	echo 'Podaj jako argumenty pliki z logami z testow PPI (np. runtest1.m)'
	echo Np\. `basename $0` \*\.log
	exit 1
