function runtest_rsctc2010
% konkurs RSCTC 2010

%datadir='c:\_users\grochu\data\rsctc2010\';  % kis-s5
%datadir='y:\\grochu\data\rsctc2010\';        % kis-s6
datadir='/home/marek/data/rsctc2010/';        % home

datasets = {'data1_train.dat' , 'data2_train.dat' ,'data3_train.dat' ,'data4_train.dat' ,'data5_train.dat', 'data6_train.dat'};

%test1(datadir,datasets);
%test2(datadir,datasets);

k=20;
test3k_split(datadir,datasets,k);





test3k_split(datadir,datasets,k);


return;


%% 21.02.2010 uczeniene QPC (kilka kierunkow) na zbiorze po losowej
%% selekcji na k partycji
function test3k_split(datadir,datasets,k)
  
    for i=1:size(datasets,2)
        datapath = strcat(datadir,datasets{i});
        fprintf('Loading dataset: %s\n',datapath);
         data=load(datapath);
        
         nf = size(data,2)-1;
         findex = randperm(nf);
         nfeat = round(nf/k);
%         freast = mod(nfeat,nf);
        
        wall = cell(k,1);
        qpcall = zeros(k,1);
        
        istart = 1;
        iend = nfeat;
        % selekcjia i uczenie QPC
        for ik=1:k
            if ik == k
                iend = nf;
            end
            fprintf('%d - %d %d\n',ik,istart,iend);
            dataname = sprintf('%s_part%03d',datasets{i},ik);
             cind = findex(istart,iend);
             [w q]=qpctrain(normalize(data(:,cind)),data(:,end),'directions',1,'plot','last','save','last','dataname',dataname,'learningRate',0.2,'maxIterations',3000);
                  
             wall{ik}=w;
             qpcall(ik)=q;
            
             istart = istart + nfeat;
             iend = iend + nfeat;
        end
        fn=strcat(dataname,'_qpc_ksplit.mat');
        save(fn,'qpcall','wall');
    end

    
return    


%% 21.02.2010 uczeniene QPC (kilka kierunkow) na zbiorze po zelekcji cech
%% za pomoca wsp. liniowej korelacji
function test2(datadir,datasets)
    nfeatures = [100 1000 5000];

for i=size(datasets,2):-1:1
    datapath = strcat(datadir,datasets{i});
    fprintf('Loading dataset: %s\n',datapath);
    data=load(datapath);
    
    % selekcjia i uczenie QPC
    for f=nfeatures
        dataname = sprintf('%s_cc%d',datasets{i},f);
        [cc cind]=corr_feat_sel(data(:,1:end-1),data(:,end),'features',f);
        w=qpctrain(normalize(data(:,cind)),data(:,end),'directions',3,'plot','last','save','last','dataname',dataname);    
        fn=strcat(dataname,'_qpc.3w.mat');
        save(fn,'w');
    end
end
return ;

function test1(datadir,datasets)
% 21.02.2010 pierwsze proby, uczeni 1 kierunka na calosci
%
for i=size(datasets,2):-1:1
    datapath = strcat(datadir,datasets{i});
    fprintf('Loading dataset: %s\n',datapath);
    data=load(datapath);
    fprintf('QPC 1 directoins learning\n');
    w=qpctrain(normalize(data(:,1:end-1)),data(:,end),'directions',1,'plot','last','save','last','dataname',datasets{i});
    fn=strcat(datasets{i},'_qpc.1w.mat');
    save(fn,'w');
end
