function runtest_qpctrain_simple(inputpath)
% porownanie jakosci i szybkosci uczenia QPC i QPC_simple (ze zmiennym
% polozeniem prototypow).
% Wynikiem jest dla kazdego zbioru
%    * wykres bgraph dla kazdego kierunku oraz scatterplot
%    * plik tekstowy z inf. o zb. danych, parametrach modelu  oraz czasie liczenia algorytmu
%    * porownanie z wynikiem dla qpc tradycyjnego

if nargin < 1
%    inputpath='c:\\_users\grochu\work\matlab\qpc\data\';  
    inputpath = '/home/marek/data/test/';
end


data = load_data(inputpath);

%method='qpc_quick';

savedir = strcat(datestr(now,'yy.mm.dd'),'.qpctrain_simple_vs_qpc/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

lr=0.1;
directions=2;
plr=0.1;
n=size(data,2);
allresults=cell(n,1);
randominit=10;

for i=1:n
        x=normalize(data(i).x);
        y=data(i).y;
        nproto = ceil(log(data(i).vectors));
        
        disp(['dataset= ' data(i).name sprintf('\t%5d',data(i).vectors) ' vectors ' sprintf(' %5d',data(i).features) ' features ' ' loaded']);
        filename=strcat(savedir,sprintf('%s.qpc_proto.k%d',data(i).name,nproto));
        f=fopen(strcat(filename,'.all.log')','w');
        fprintf(f,'dataset= %s\nvectors= %d\nfeatures= %d\n',data(i).name,data(i).vectors,data(i).features);

        
        
        fprintf('Evaluating QPC_proto\n');

        
        tic;
        [bw aqpc bp]=qpctrain_simple(x,y,'initiations',randominit,'prototypes',nproto,'plr',plr,'learningRate',lr,'display','short','directions',directions,'dataname',data(i).name);
        t1=toc;
        fprintf(f,'Method= QPC_simple\ndirections= %d\nprototypes= %d\ntime= %f\n',directions,nproto,t1);
        qpc1=qpcfunction(x,y,bw);

        results.dataname = data(i).name;
        results.vectors = data(i).vectors;
        results.qpc_simple_aqpc = aqpc;
        results.qpc_simple_qpc = aqpc;
        results.qpc_simple_time = t1;
        results.qpc_simple_w = bw;
        results.qpc_simple_proto = bp;
 
        % qpc=qpcfunction(x,y,bw);

        str=cell(1,3);
        for d=1:directions
             fprintf(f,'aQPC%d=%6.3f\nQPC%d=%6.3f\n',d,aqpc(d),d,qpc1(d));

             str{1}='';
             str{2}=sprintf('aQPC = %0.3f',aqpc(d));
             str{3}=sprintf('QPC = %0.3f',qpc1(d));
             clf;
             bgraph(x*bw(d,:)',y,'weights',bw(d,:),'str',str,'stralign','right');
             hold on;
             p = bp{d};
             bgraph(p(:,1:end-1)*bw(d,:)',p(:,end),'select','yes','borders','yes');
             saveplot(sprintf('%s.bgraph.d%d',filename,d));
        end
        clf;
        scaterplot(x*bw',y,'features',1:directions);
        saveplot(sprintf('%s.scatter',filename));                
        fclose(f);
        
        %%%%%%%%%% to samo dla tradycyjnego QPC
        filename=strcat(savedir,sprintf('%s.qpc.gauss.0.1',data(i).name));
        f=fopen(strcat(filename,'.all.log')','w');
        
        fprintf('Evaluating QPC\n');
        init = 10;
        tic;
        [bw bqpc]=qpctrain(x,y,'OptMethod','gd','QPCMethod','qpc','initiations',init,'learningRate',lr,'display','short','directions',directions,'dataname',data(i).name);

        
        t1=toc;

        results.qpc = bqpc;
        results.time = t1;
        results.w = bw;
     
        
        fprintf(f,'Method= QPC\ndirections= %d\ntime= %f\n',directions,t1);
        str=cell(1,2);
        for d=1:directions
             fprintf(f,'QPC%d=%6.3f\n',d,bqpc(d));

             str{1}='';
             str{2}=sprintf('QPC = %0.3f',bqpc(d));
             clf;
             bgraph(x*bw(d,:)',y,'weights',bw(d,:),'str',str,'stralign','right');
             saveplot(sprintf('%s.bgraph.d%d',filename,d));
        end
        clf;
        scaterplot(x*bw',y,'features',1:directions);
        saveplot(sprintf('%s.scatter',filename));                
        fclose(f);
    
        
        allresults{i}=results;
  %  catch
  %  end
end

save(strcat(savedir,'allresuts.mat'),'allresults');


function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);