function runtest_qpc_quick(inputpath)
% test dla szeregu dancyh

if nargin < 1
%    inputpath='c:\\_users\grochu\work\matlab\qpc\data\';  
    inputpath = '/home/marek/data/test/';
end

files = dir(inputpath);

if isdir(inputpath) == 1
    directory=strcat(inputpath,'/');
else
    directory=strcat(fileparts(inputpath),'/');
end

%method='pca';
method='qpc_quick';

savedir = strcat(datestr(now,'yy.mm.dd'),'.qpcquick/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

krange=[10 50 90];
brange=[0.5 1 2];

lr=0.1;
directions=1;

n=size((files),1);

for i=1:n
   % try 
        if files(i).isdir == 1
            continue
        end
        file=strcat(directory,files(i).name);
        [path datasetname]=fileparts(file);
        
        data = load(file);
        [v f]=size(data);
        x=normalize(data(:,1:end-1));
        y=data(:,end);
        disp(['dataset: ' datasetname sprintf('\t%5d',v) ' vectors ' sprintf(' %5d',f-1) ' features ' ' loaded']);
        logfile=strcat(savedir,sprintf('%s.qpc_quick.gauss.0.1',datasetname));
        f=fopen(strcat(logfile,'.all.log')','w');
        aprqpc = 0;
        bqpc = -1;
        bk =0;
        bb =0;
        
        for k = krange
           for b = brange
                fprintf('Evaluating qpcquick for k=%d b=%f\n',k,b);
                filename=strcat(logfile,sprintf('.k%d.b%.1f',k,b));
                [bw aprqpc]=qpctrain(x,y,'OptMethod','qpcquick','beta',b,'prototypes',k,'learningRate',lr,'display','short','directions',directions);
                qpc=qpcfunction(x,y,bw);

                str{1}='';
                str{2}=sprintf('QPC = %0.3f',qpc);
                str{3}=sprintf('aQPC = %0.3f',aprqpc);
                clf;
                bgraph(x*bw',y,'weights',bw,'str',str,'stralign','right');
                saveplot(sprintf('%s.bgraph.d%d',filename,1));                
                
                fprintf(f,' k=%3d  b=%3.1f QPC=%6.3f appr.=%6.3f\n',k,b,qpc,aprqpc);
                if qpc > bqpc 
                    bqpc = qpc;
                    bb = b;
                    bk = k;
                end
                
                if directions > 1
                    clf;
                    scaterplot(x*bw',y,1:directions);
                    saveplot(sprintf('%s.scatterplot.all',filename));
                end
           end
        end
        fprintf(f,'Best:\n k=%3d  b=%3.1f QPC=%6.3f appr.=%6.3f\n',bk,bb,bqpc);
        fclose(f);
  %  catch
  %  end
end

function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);