function all_results=runtest_icann2010_qpc_nb(inputpath)
% Ostatecznie wyniki testu opublikowane zostay na konf. ICANNGA'11.
% klasyfikacja danych 10x10CV 
% 1 Naiwny Bayes (kernel)  - kernel dtribution (not normal)
%         12/1/2011 - repeated for NB with normal distribution
% 2 QPC + NB (kirunki 3, 2, 1)
% 3 QPCproto + NB (kierunki 3,2,1)

if nargin < 1
%   inputpath='c:\\_users\grochu\work\matlab\qpc\data\';
%   inputpath = '/home/grochu/data/icann2010';
%    inputpath = '/home/grochu/data/icann2010/sonar.dat';
    inputpath = '/home/marek/data/test/';
end

data = data_load(inputpath);

savedir = strcat(datestr(now,'yy.mm.dd'),'.cv_qpc_nb_kernel/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end

NData = size(data,2);
NVect = zeros(1,NData);
for i=1:NData
    NVect(1,i)=data(i).vectors;
end
[s idx]=sort(NVect);

directions=3;

% NaiveBayes
nn=1;
%model(nn).train =@(x,y)NaiveBayes.fit(x,y,'Distribution','kernel');
model(nn).train =@(x,y)NaiveBayes.fit(x,y,'Distribution','normal');
model(nn).test =@(x,y,m)nbtest(x,y,m);
model(nn).info = 'NaiveBayes(normal)';

% QPC + NB na DRECTIONS..1 kierunkach (QPC uczone tylko raz, wagi przekazywane
% przez zmienna globalna)
is_w = 0;   % czy uzyc zmiennej globalnej
for di=directions:-1:1
    nn=nn+1;
    model(nn).train =@(x,y)qpc_nb_train(x,y,di,'qpc',is_w);
    model(nn).test =@(x,y,m)qpc_nb_test(x,y,m);
    model(nn).info = sprintf('QPCw%02d+NB(normal)',di);
    is_w = 1;
end

% QPC_proto z inicjalizacja na interwalach + NB
is_w = 0;
for di=directions:-1:1
    nn=nn+1;
    model(nn).train =@(x,y)qpc_nb_train(x,y,di,'qpc2',is_w);
    model(nn).test =@(x,y,m)qpc_nb_test(x,y,m);
    model(nn).info = sprintf('QPC2w%02d+NB(normal)',di);
    is_w = 1;
end

models = model(:);
NModels=length(models);

folds = 3;
repetitions = 2;

for i=idx
        % data(i).x=normalize(data(i).x);
        cr.dataname = data(i).name;
        cr.vectors = data(i).vectors;
        cr.folds = folds;
        cr.repetitions = repetitions;

        disp(['dataset= ' data(i).name sprintf('\t%5d',data(i).vectors) ' vectors ' sprintf(' %5d',data(i).features) ' features ' ' loaded']);

        try
            filename=strcat(savedir,sprintf('%s.cv_nb',data(i).name));
            f=fopen(strcat(filename,'.all.log')','w');
            fprintf(f,'dataset= %s\nvectors= %d\nfeatures= %d\n',data(i).name,data(i).vectors,data(i).features);
            fprintf(f,'folds= %d\nrepetitions=%d\n',folds,repetitions);

            logfilename=strcat(savedir,data(i).name,sprintf('-%2dx%2dcv-',folds,repetitions),datestr(now,'yymmdd-HHMM'),'.log');
            % CV test
            [acc1 std1 cr.results]=cv(data(i).x,data(i).y,models,folds,repetitions,logfilename);

            % Results Saving
            fprintf(f,'Model\tAccuracy\tStd.\tTime\n');
            for m=1:NModels
                fprintf(f,'%d %s\t%8.4f\t%8.4f\t%8.4f\tTTest corr.:',m,models(m).info,acc1(m),std1(m),cr.results(m).avg_time);
                for m2=1:NModels
                    fprintf(f,' [%d] %.4f ',m2,cr.results(m).ttest(m2));
                end
                fprintf(f,'\n');
            end

            fprintf(f,'\nSummary\n%s',cr.dataname);
            for m=1:NModels
                fprintf(f,'\t%6.2f\t%6.2f [%.4f]',acc1(m),std1(m),cr.results(1).ttest(m));
            end
            fprintf(f,'\n');

            fclose(f);
            filename = strcat(savedir,data(i).name,'.cv.mat');
            save(filename,'cr');

        catch exception
            ff=fopen(strcat(savedir,'error.log'),'a');
            fprintf(ff,'%s\n',exception.message);
            disp(exception);
            fclose(ff);
        end
        
        all_results{i} = cr;

        clear cr;
end

filename = strcat(savedir,'all_results.mat');
save(filename,'all_results');