function out=runtest4(inputpath)
% wplyw szerokowsi funkcji G() na wyniki
%
% glownie dla Monk's 1 

if isdir(inputpath) == 1
    ft = ls(inputpath);
    files = ft(3:end,:);
    dir=strcat(inputpath,'/');
else
    files=inputpath;
    dir='';
end

ni = 1; % number of initiations
lr = 0.1; %learningRate
%b = [0.5 1 2 5 7 10];  % beta
b = [1 2 ];  % beta
fn = 'fx4'; %function
n=size((files),1);
iter = 100;
lambda = 1;

out=cell(n,1);

for i=1:n
    try 
        file=strcat(dir,files(i,:));
        [d datasetname]=fileparts(file);
        data = load(file);
        [v f]=size(data);
%         if (nargin < 2)
%              x=data(:,1:end-1);
%         else
             x=normalize(data(:,1:end-1));
%         end;
        y=data(:,end);
        disp(['dataset: ' datasetname sprintf('\t%5d',v) ' vectors ' sprintf(' %5d',f-1) ' features ' ' loaded']);

        for bi=b
           [w1 ppi1]= qpctrain(x,y,'maxiterations',iter,'initiations',ni,'learningRate',lr,'function',fn,'beta',bi,'eps',0.001,'dataname',datasetname,'save','last');
%           [w2 ppi2]= ppoptimize4(x,y,'maxiterations',iter,'initiations',ni,'learningRate',lr,'function',fn,'beta',bi,'ortoWeights',w1,'lambda',lambda,'eps',0.001,'dataname',datasetname,'save','last');
        end
        out{i}=struct('name',datasetname,'ppi',ppi2,'w1',w1,'w2',w2);
% stara wersja matlaba
    catch
        disp(lasterror);
        out{i}=struct('name',datasetname,'comment','error');
% w nowej wersji MATLABA
%     catch M
%         disp(M);
    end
    %    ppoptimize2(x,y(:,end),'lrate',0.2,'fx4',10,'plotall','eps',0.005,'dataname',strcat(files(i,:),'-fx4-10'));
end

fprintf('\nFinal resulta\n');
for i=1:n
    disp(out{i});
end
