function runtest2(inputpath)

files = dir(inputpath);

if isdir(inputpath) == 1
    directory=strcat(inputpath,'/');
else
    directory=strcat(fileparts(inputpath),'/');
end

ni = 10; % number of initiations
lr = 0.2; %learningRate

fn = 'fx4';        b = 2; %function
%fn = 'bicentral';   b = 0.3; %function

n=size((files),1);

for i=1:n
    try 
        if files(i).isdir == 1
            continue
        end
        file=strcat(directory,files(i).name);
        [path datasetname]=fileparts(file);
        
        data = load(file);
        [v f]=size(data);
        x=normalize(data(:,1:end-1));
        y=data(:,end);
        disp(['dataset: ' datasetname sprintf('\t%5d',v) ' vectors ' sprintf(' %5d',f-1) ' features ' ' loaded']);
        w2 = qpctrain(x,y,'initiations',ni,'learningRate',lr,'function',fn,'beta',b,'eps',0.001,'dataname',datasetname,'save','last');

%        for la=[0.1 0.5 1]
        for la=1
            qpctrain(x,y,'initiations',ni,'learningRate',lr,'function',fn,'beta',b,'ortoWeights',w2,'lambda',la,'eps',0.001,'dataname',datasetname,'save','last');
        end

% stara wersja matlaba
    catch
        disp(lasterror);
% w nowej wersji MATLABA
%     catch M
%         disp(M);
    end

end

