function runcvtesticann09compMLP(data)
% test CV test in icann 09 competiton data
% CC + MLP regresion


%ccoeff=[0.8 0.75 0.7 0.5 0.3 0.1];
ccoeff=[0.665 0.655 0.645 0.635];
%ccoeff = 0.8;
%kn = 1;
%nn = [1 3 5 10 15 20];  % number of hidden neurons
nn = [1];

folds = 10;
repetitions = 3;

vn = size(data,1);

savedir = strcat(datestr(now,'yy.mm.dd'),'.cvtestICANN09comp/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end
method='ccMLP';

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv.log');
logfile = fopen(logfilename,'wt');

testtransform=@(x,a)normalize(x,a);
traintransform=@(x)normalize(x);
results.mse = zeros(folds,repetitions);

% x=data(:,1:end-1);
% y=data(:,end);

lr=0.1;
maxIter=1000;
eps=0.001;

for cc=ccoeff
          corrcc = corr_feat_sel(data(:,1:end-1),data(:,end));
          ccid=find(corrcc >= cc);
          nf=length(ccid);
          x=data(:,ccid);
          y=data(:,end);
   
    for k=nn
        for n=1:repetitions
             indices = crossvalind('Kfold',vn,folds);
             for i=1:folds
                  fprintf(' CV Test %d/%d fold %d/%d n=%2d cc=%4.2f',n,repetitions,i,folds,k,cc);
                  trainid=(indices~=i);

                  [trainx a]=traintransform(x(trainid,:));
                  testdata=testtransform(x(~trainid,:),a);
                  trainy=y(trainid);
                  testy=y(~trainid);
                  
                  net = mlptrain_reg(trainx,trainy,k,lr,maxIter,eps);
                  mser=mlptest_reg(testdata,testy,net);
                  results.mse(i,n) = mser;

                fprintf(' MSE=%6.3f train %6.3f feat %3d\n',mser,net.trainmse,nf);
   %         fprintf(' Test acc. %4.1f hidden %d prototypes %d\n',acc,net.nw,net.np);
             end
        end

        [results.mse_avg results.mse_std]= stats(results.mse);
        fprintf('Avg.MSE=%7.4f  std.=%7.4f  cc=%6.2f  n=%2d  nf=%5d\n',results.mse_avg,results.mse_std,cc,k,nf);
        fprintf(logfile,'Avg.MSE=%7.4f  std.=%7.4f  cc=%6.2f  n=%2d  nf=%5d\n',results.mse_avg,results.mse_std,cc,k,nf);
    end
end

fclose(logfile);

return;


function [omean ostd]=stats(table)
    mean1 = mean(table,1);  
    std1  = std(table,1);
    omean=mean(mean1); 
%    std2=std(mean1);
    ostd=mean(std1); 
    %std3=std(std1);





function [mean2 std2]=printresults(table)
    [folds tests]=size(table);
    fprintf('Test : %s \n',sprintf(' %6d',1:tests));
    fprintf('------ \n');
    for i=1:folds
        fprintf('%2d fold %s\n',i,sprintf(' %6.2f',table(i,:)));
    end
    fprintf('------ \n');
    mean1 = mean(table);  
    std1  = std(table);
    mean2=mean(mean1); std2=std(mean1);
    mean3=mean(std1); std3=std(std1);

    fprintf('Avg  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',mean1),mean2,std2);
    fprintf('Std  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',std1),mean3,std3);

    return;

        
        
        


