function runcvtesticann09comp(data)
% test CV test in icann 09 competiton data
% CC + KNN regresion


ccoeff=[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.75 0.8];
%ccoeff = 0.8;
%kn = 1;
kn = 1:20;

folds = 10;
repetitions = 10;

vn = size(data,1);

savedir = strcat(datestr(now,'yy.mm.dd'),'.cvtestICANN09comp/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end
method='cckNN';

logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv.log');
logfile = fopen(logfilename,'wt');

testtransform=@(x,a)normalize(x,a);
traintransform=@(x)normalize(x);
results.mse = zeros(folds,repetitions);

x=data(:,1:end-1);
y=data(:,end);

for cc=ccoeff
    for k=kn
        for n=1:repetitions
             indices = crossvalind('Kfold',vn,folds);
             for i=1:folds
                  fprintf('CV Test %d/%d fold %d/%d ',n,repetitions,i,folds);
                  trainid=(indices~=i);

                  [traindata a]=traintransform(x(trainid,:));
                  testdata=testtransform(x(~trainid,:),a);
                  
                  corrcc = corr_feat_sel(traindata,y(trainid));
                  ccid=find(corrcc >= cc);
                  nf=length(ccid);
                  out1 = knn_reg(traindata(:,ccid),y(trainid),testdata(:,ccid),k);
                  mser=mseerr(out1,y(~trainid));
                  results.mse(i,n) = mser;

                fprintf(' MSE. %6.3f \n',mser);
   %         fprintf(' Test acc. %4.1f hidden %d prototypes %d\n',acc,net.nw,net.np);
             end
        end

        [results.mse_avg results.mse_std]= stats(results.mse);
        fprintf('avg.MSE=%7.4f  std.=%7.4f  cc=%6.2f  k=%2d  nf=%5d\n',results.mse_avg,results.mse_std,cc,k,nf);
        fprintf(logfile,'avg.MSE=%7.4f  std.=%7.4f  cc=%6.2f  k=%2d  nf=%5d\n',results.mse_avg,results.mse_std,cc,k,nf);
    end
end

fclose(logfile);



return;


function [omean ostd]=stats(table)
    mean1 = mean(table,1);  
    std1  = std(table,1);
    omean=mean(mean1); 
%    std2=std(mean1);
    ostd=mean(std1); 
    %std3=std(std1);





function [mean2 std2]=printresults(table)
    [folds tests]=size(table);
    fprintf('Test : %s \n',sprintf(' %6d',1:tests));
    fprintf('------ \n');
    for i=1:folds
        fprintf('%2d fold %s\n',i,sprintf(' %6.2f',table(i,:)));
    end
    fprintf('------ \n');
    mean1 = mean(table);  
    std1  = std(table);
    mean2=mean(mean1); std2=std(mean1);
    mean3=mean(std1); std3=std(std1);

    fprintf('Avg  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',mean1),mean2,std2);
    fprintf('Std  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',std1),mean3,std3);

    return;

        
        
        


