function [p err select]=removeprototypes(x,y,p,doucz,epsilon)
% usuwa prototypy ktore nie psuja klasyfikcji
% jesli DOUCZ == 1 wtedy po kazdym usunieciu douczanie LVQ z mala stala
% jesli DOUCZ == 2 douczanie tylko na koncu
% uczenia

if nargin < 4;  doucz = 2; end
if nargin < 5;  epsilon = 0.01; end


% switch (doucz)
%     case 1 
%         errorfunction = @(xx,xy,px,py)llvqtrain(xx,xy,'initp',[px py],'lvqlr',0.01,'linear','no','maxiterations',50);
%     case 2 :
%     otherwise
%         
% end

[px py]=datap(p);
np=size(px,1);
select = ones(1,np);  % select all prototypes
besterr=lvqerror(x,y,p);

%while stop == 0
id = randperm(np);
for i=1:np
    if select(id(i)) == 1
        select(id(i)) = 0;
        px1 = px(select==1,:);
        py1 = py(select==1);

        if doucz == 1
           [p2 w cerr]=llvqtrain(x,y,'initp',[px1 py1],'lvqlr',0.01,'linear','no','maxiterations',50);
        else
            cerr = lvqerror(x,y,[px1 py1]);
        end

        if cerr > besterr + epsilon  % cofamy, za duzo psuje
            select(id(i))=1;
        else
            if doucz == 1
                px(select==1,:)=p2(:,1:end-1);
            end
        end
    end        
%       stop = 1; % all prototypes are neaded
end
%end
p=[px(select==1,:) py(select==1)];
err =lvqerror(x,y,p);

% douczanie na koncu
if doucz == 2
   [p2 w err2]=llvqtrain(x,y,'initp',p,'lvqlr',0.01,'linear','no');
   if err2 <= err
       p = p2;
       err = err2;
   end
end

