function [bestw bestqpc bestproto info]=qpctrain_proto(data,varargin)
% uczenie z QPC z prototypami
%   * prototypy losowe/w centrach klas/zbalansowana ilosc wg. klass/dobrana
%   recznie
%   * prototypy zainicjowane za pomoca szybkiego algorytmu QPC poprzez
%   wybrane losowego rzutu dajacego najwyzsza wartosc indeksu.
%
%   W = QPCTRAIN_PROTO(X,Y,PARAMETERS,VALUE,...)
%	searching for optimal W witch maximize QPC index value
%	X : dataset
%	Y : labels
%
%   W = QPCTRAIN_PROTO(DATA,PARAMETERS,VALUE,...)
%   DATA : data structure created by LOAD_DATA function 
%    e.g LOAD_DATA([X Y]).
%   
%   For QPC learning options refer to "help qpc_config".
%
%   Prototypes options:
%          'ProtMethod' - initiation of prototypes (default 'means')
%               'qpcquick'   - use random direction to estimate prototype
%               positions and class associations (use 'initiations' to set
%               up numer of random directions, the best one is choosen)
%               'balanced'   - balance class labels depend on size of classses
%               'fixed'      - fixed proportions
%               'means'      - put prototypes in class means (one per class)
%                Use 'prototypes' to set up number/fraction of prototypes
%                to init. This value mihgt be 
%                * scalar intiger - overall number of prototypes
%                * scalar real [0,1) - fraction of number of data points
%                * vector [1xnumber of class] of integers
%                * vector [1xnumber of class] of real numbers beetwen [0,1)
%
%	e.g.   w=qpctrain_proto(x,y,'directions',2,'prototypes',10)

if nargin < 1; error('Give me some data, please.'); end;
if ~isstruct(data);
    data=data_struct([data varargin{1}]);
    [qpc_parameters unmached] = qpc_config(varargin{2:end});
else
    [qpc_parameters unmached] = qpc_config(varargin{:});
end

if qpc_parameters.plr == 0 
    qpc_parameters.plr = qpc_parameters.learningRate;
end

qpc_parameters.QPCMethod = 'proto';

proto_parameters = qpctrain_proto_config(unmached);

% disp(qpc_parameters);
% disp(proto_parameters);
% disp(data);

directions = qpc_parameters.directions;
%ortmethod   = param.Results.orthogonalizationMethod;

qpclearning = @(x,y,p)qpc_1d(x,y,p);

%[vx fx]=size(x);

bestw = zeros(directions,data.features);
bestqpc = zeros(directions,1);
bestprot = cell(directions,1);

if directions > data.features; directions = data.features ; end 

is_qpcquick = strcmp(proto_parameters.ProtMethod,'qpcquick') == 1;
if is_qpcquick
    intervals = qpc_parameters.prototypes;
end
%xp=x;

x1=zeros(data.vectors,directions);

%parameters.initiations = 1;
acc1=zeros(directions,1);
acc=zeros(directions,1);

for dirCount = 1:directions
    logfilename = sprintf('%s.qpc_simple.%s.%0.1f',qpc_parameters.dataName,qpc_parameters.function,qpc_parameters.beta);

    if dirCount == 1
        P =  [];
        xp = data.x;
    else
        P=eye(data.features)-bestw'*bestw;  % operator projekcji na podprz. otronormalna
        xp=data.x*P;        
    end
    qpc_parameters.logfilename=sprintf('%s.d%d',logfilename,dirCount);
%    [bw bqpc qpctable]=qpclearning(xp,y,qpc_parameters);


    bqpc = -Inf;
    bw = [];
%    bparam = struct([]);
    
    for init=1:proto_parameters.Repetitions
        % prototypes initiation
        if is_qpcquick
            w1=qpctrain(xp,data.y,'prototypes',intervals,'directions',1,'initiations',qpc_parameters.initiations,'OptMethod','random','QPCMethod','quick','function',qpc_parameters.function,'beta',1);
            [qpc1 p1 sigma1]=qpcfunction_quick(xp,data.classInfo,w1,intervals);
            p2=project_points(p1(:,1:end-1),w1,mean(xp));
            qpc_parameters.prototypes = [p2 p1(:,end)];
            qpc_parameters.beta = sigma1;
            qpc_parameters.initWeights;
            qpc_parameters.initiations = 1;

    %        disp(sigma1);
    %         disp(p1);
    %         disp(qpc_parameters.prototypes);
    %         disp(qpc_parameters.prototypes(:,1:end-1)*w1');
    %         bgraph(data.x*w1',data.y);
    %         bgraph(qpc_parameters.prototypes(:,1:end-1)*w1',qpc_parameters.prototypes(:,end),'select','yes');
    %         pause;

        else
            qpc_parameters.prototypes = prototypes_init(xp,data.y,qpc_parameters.prototypes,proto_parameters.ProtMethod);
        end
    

        [w2 qpc2 param2]=qpclearning(xp,data.y,qpc_parameters);

        if qpc2 > bqpc
            bqpc = qpc2;
            bw = w2;
            bparam = param2;
        end

    end
    
    px=bparam.prototypes(:,1:end-1);
    
    if dirCount > 1
        bw=bw*P;
        px=px*P;
    end
    
    bestproto{dirCount} = [px qpc_parameters.prototypes(:,end)];
    bestw(dirCount,:)=bw; %/norm(bw);
    bestqpc(dirCount)=bqpc;
    info{dirCount} = bparam.info;


    x1(:,dirCount)=data.x*bestw(dirCount,:)';
    pwx{dirCount} = bestproto{dirCount}(:,1:end-1)*bestw(dirCount,:)';
    acc(dirCount)=1-lvqerror(x1(:,1:dirCount),data.y,[[pwx{1:dirCount}] qpc_parameters.prototypes(:,end)]);
    acc1(dirCount)=1-lvqerror(x1(:,dirCount),data.y,[pwx{dirCount} qpc_parameters.prototypes(:,end)]);    
    
    if strcmp(qpc_parameters.save,'all') || strcmp(qpc_parameters.save,'last')
       
        clf;
        bgraph(x1(:,dirCount),data.y);
        hold on;
        bgraph(pwx{dirCount},bestproto{1}(:,end),'select','yes','borders','yes');
        saveplot(sprintf('%s.bgraph.d%d',logfilename,dirCount));
        
        for f=2:dirCount
            clf;
            scaterplot(x1,data.y,[f-1 dirCount]);
            scaterplot([pwx{:}],bestproto{1}(:,end),[f-1 dirCount],'select','yes','borders','yes');
            saveplot(sprintf('%s.scatterplot.d%d-%d',logfilename,f-1,dirCount));
        end
    end
end

if directions > 1 && (strcmp(qpc_parameters.save,'all') || strcmp(qpc_parameters.save,'last'))
    clf;
    scaterplot(data.x*bestw',data.y,1:directions);
    scaterplot([pwx{:}],bestproto{1}(:,end),1:directions,'select','yes','borders','yes');
    saveplot(sprintf('%s.scatterplot.all',logfilename));
    plik=fopen(sprintf('%s.weights.all.log',logfilename),'w');
    for i=1:directions
        
        fprintf(plik,sprintf('Direction %2d\n',i));
        fprintf(plik,sprintf('QPC=%6.4f\n',bestqpc(i)));
        fprintf(plik,sprintf('LVQ acc.=%6.4f\n',acc(i)));
        fprintf(plik,sprintf('LVQ 1D acc.=%6.4f\n',acc1(i)));
        fprintf(plik,strcat('w=',sprintf(' %6.4f',bestw(i,:))));
        fprintf(plik,'\nPrototypes\n');
        
        for j=1:size(bestproto{i},1)
            fprintf(plik, '%6.4f ',bestproto{i}(j,1:end-1));
            fprintf(plik, '%d',bestproto{i}(j,end));
            fprintf(plik,'\n');
        end
        fprintf(plik,'\n');
    end
    fclose(plik);
    
end

return
function saveplot(prefix)
 	name = strcat(prefix,'.png');
 	print('-dpng','-r96',name);
% % octave only
% %	print('-dpng','-S640,480',name);


%    name = strcat(prefix,'.eps');
%  	 print('-depsc',name);

function [parameters unmached]=qpctrain_proto_config(varargin)

param = inputParser;
param.KeepUnmatched = true;
% data
% param.addRequired('x',@isnumeric);
% param.addRequired('y',@isnumeric);
param.addOptional('ProtMethod','means',@(x)any(strcmpi(x,{'qpcquick','fixed','balanced','means'})));
param.addOptional('Repetitions',1,@isnumeric);

param.parse(varargin{:});
parameters = param.Results;
unmatched = param.Unmatched;
unames=fieldnames(unmatched);
clear param;

if nargout  < 2 && size(unames,1) > 0
        error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
end


return;
