function [net trainacc]=qpcnet(data,varargin)
% QPCNET  Create and train constructive neural network QPCNN.
%    NET = QPCNET(X,Y)
%    NET = QPCNET(D)
%    NET = QPCNET(X,Y,OPTIONS)
%
%    X - training data
%    Y - training data labels
%    D - data struct = data_struct()
%
%    Options:
%        For QPC options see 'help qpc_config'.
%
%    QPCNET options:
%       'NetMethod' : set training method 'qpc' or 'qpc2' (default).
%                Method 'qpc2' use prototypes thus is much more faster. It
%                use also more sofisticated heuristics for neuron
%                selection.
%
% TODO
% * dokonczyc opis opcji
% * co robic gdy neuron nie potrafi odeseparowac? Iloczyn neuronow lub f.
% radialna.
% douczanie konfliktowych przypadkow w ortogonalnej przestrzeni
%
% DONE
% * kryterium stopu roznocej sieci - kiedy przestac? (done - zatrzymuje gdy nie rosnie dokladnosc, lub gdy juz nie ma nic do uczenia)
%
% Algorithm:
%  1. Chooce class  (see note below)
%  2. Create and learn partial classifier for selected class
%  3. Remove vectors classified by PC from selected class (or use boosting,
%  decrease probability for choosing corectly handled vectors for next
%  training)
%  4. If there are two samples frome different class then go to 2
%  5. Construct net with PC in hidden node
%
%  Creating and learnong of single PC (step 2)
%  1. Optimize QPC (or QPC proto)
%  2. Find k-separable solution
%  3. Take best interval; with highest separation rate, e.g.:
%  np(i)/npall(c) - (nn(i)-np(i))/(vectors - npall(c)), where i - interval
%  id, c - class of interval i.
%  4. Asocciate treshold/window neuron and adjust weights
%  5. If not partial classifier (np(i)/nn(i) < (1-epsilon) then
%     split dataset and train another node only for samples inside current
%     interval (go to 1)
%  6. Else, retunrn PC
%
% Choosing class:
% variant 1 : pure random (or balanced by class size), not implemented
% variant 2 : 
% 1. Train QPC (or faster QPC_proto 'qpc2') and choose class (or associated with 
% prototype) with the highest index value.
% 2. Choose nauron type using some heuristics:
%    a. Sigmoid - if cluster is located at the left or right side of
%    projection
%    b. Window neuron - if cluster is located inside the projected vectors
%    c. Radial function - if sigmoid and window function are not able to
%    cover located cluster 

if nargin < 1; error('Give me some data, please.'); end;
if ~isstruct(data);
    data=data_struct([data varargin{1}]);
    [parameters unmached] = qpc_config(varargin{2:end});
else
    [parameters unmached] = qpc_config(varargin{:});
end

if parameters.plr == 0 
    parameters.plr = parameters.learningRate;
end

qpc_parameters.QPCMethod = 'proto';

net_parameters = qpcnet_config(unmached);




%[vx fx]=size(x);

beta        = parameters.beta;
lrate       = parameters.learningRate;	% learning rate (step of gradnient descent)
eps         = parameters.eps;	% 
nmax        = parameters.maxIterations;     % nax. number of iterations
%pplot       = 0;
%lastppi     = -1;
% ffplot      = 0;
ninit       = parameters.initiations;
%ww          = parameters.initWeights;
dataname    = parameters.dataName;
%avgtest     = parameters.checkPeriod;
%stopcriterium = parameters.stopCriterium;
%iGmax       = parameters.indGmax;
%wort        = parameters.ortoWeights;
%lambda      = parameters.lambda;
%orto        = ~isempty(wort);
funcname    = parameters.function;
%wo          = 0;
%saveall     = 0;
%savelast    = 0;
%savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));
%procedure   = '';

epsilon = 0.05;  % procent dopuszczalnych bledow w klastrze
nnn=2;
%bestw = [];
%bestppi = [];
%bestinit = 0;
%bestn = 0;
%bestigmax = -1;

%if ~isempty(parameters.savedir)
%    savedir = parameters.savedir;
%end

switch parameters.display
    case 'all'
        display = 2;
    case 'short'
        display = 1;
    case 'none'
        display = 0;
end

% k= 1;

%ory = y;
%orx = x;

labelsIndex = [data.classInfo.labelsIndex{:}];
lasttrainacc = 0;

net = cell(1,1);

x=data.x;
y=data.y;
vectorsCount = data.vectors;
features= data.features;


is_qpc2 = strcmp(net_parameters.NetMethod,'qpc2');
is_plotall = strcmp(parameters.plot,'all');
labelsPerClassCount = data.classInfo.labelsPerClassCount;
learning = 1;

while learning
    fprintf('QPCTrain running\n');
    
    %%%%%%%%%%%%  Find QPC projection %%%%%%%%%%%%%%%
    
    if ~is_qpc2
        w = qpctrain(x,y,'initiations',ninit,'learningRate',lrate,...
            'function',funcname,'beta',beta,'eps',eps,'dataname',...
            dataname,'directions',1,'plot','none');
        
        [~, ~, ~, G]=qpcfunction(x,y,w,[],@(x)f_gauss(x,beta,0));
        [~, imax]=max(G);

    else
         [w , ~, proto]=qpctrain_proto(x,y,'ProtMethod','qpcquick',...
             'prototypes',parameters.prototypes,'initiations',parameters.initiations,...
             'plr',parameters.learningRate,'learningRate',parameters.learningRate,...
             'display','short','directions',1,'dataname',data.name,'beta',1);

         prototypes = proto{1};
    end

    if is_plotall
        proj=x*w';
        figure(1);
        clf;

        bgraph(proj,y,'weights',w);
        
        if ~is_qpc2
            fprintf(1,'Xmax=%f\n',proj(imax));
            prototypes=[x(imax,:) y(imax)];
        end
        
        hold on;
        bgraph(prototypes(:,1:end-1)*w',prototypes(:,end),'select','yes','borders','yes');
    end

    %%%%%%%%%%%%% Adjust cluster separation (associate node with best cluster) %%%%%%%%%%%%%%%%%%%%%%
    %%% best clusrer: max_i (np/npall -(nn-np)/(vectros-npall))
    if ~is_qpc2
        [pc node ic cl]=clusteroptimize(x,y,w,'indGmax',imax,'plot','all',...
            'ClusterMethod','qpc','display','short');

        if is_plotall
            figure(3);
            clf;
            disp(node.a);
            disp(node.b);
            bgraph(x*node.w',y);
        end
    else
        [tr klabels] = proto2ksep(w,p);  % granice k-sep
        proj = x*w';
        k = length(klabels);
        
    %   classcum = zeros(data.classInfo.labelsCount,1);
        knp = zeros(1,k);
        knn = zeros(1,k);
        npall = zeros(1,k);
    %   nncum = 0;
        
        knn(1) = nnz(proj < tr(1));
        knp(1) = nnz(labelsIndex(proj < tr(1),klabels(k)==data.classInfo.labels));
        
        for j=2:k-1
            knn(j) = nnz(proj >= tr(j-1) & proj < tr(j));
            knp(j) = nnz(labelsIndex(proj >= tr(j-1) & proj < tr(j),klabels(j)==data.classInfo.labels));
        end
        knn(k) = nnz(proj >= tr(end));
        knp(k) = nnz(labelsIndex(proj >= tr(end),klabels(k)==data.classInfo.labels));
              
        for j=1:k
            npall(j)=labelsPerClassCount(klabels(j)==data.classInfo.labels);
        end

 %      npfrac = knp./vectorsCount; % stare kryterium - nie dobre
        npfrac = knp./npall - (knn-knp)./(vectorsCount-npall);
        [maxnpfrac maxind]=max(npfrac);
%         knp
%         knn
%         sum(knn)
%         npfrac
%         klabels
%         tr
%         
%         figure(1);
%         clf;
%         bgraph(proj,y,'borders',tr');
%        return;
        
        switch maxind
            case 1
                w=-w;
                
                %func = @(x,a,s)f_sigm_inv(x,a,s);
                tresholds = -tr(1);
                func = @(x,a,s)f_sigm(x,a,s);
                %func = @(x,a,b)(1 - f_sigm(x,a));
            case k
                %func = @(x,a,b)f_sigm(x,b);
                func = @(x,a,s)f_sigm(x,a,s);
                tresholds = tr(end);
            otherwise
                tresholds = [tr(maxind-1) tr(maxind);];
              %  func = @(x,a,b)f_bicentral(x,b-a,0.5*(b+a),10);
                func = @(x,a,b,s)f_bicentral2(x,a,b,s);
%                func = @(x,a,b,s)f_bisigm(x,a,b,s);
        end

        [err node ic cl]=clusteroptimize_mse(x,y,w,'label',klabels(maxind),'ClusterFunction',func,'tresholds',tresholds,'plot','all','display','short');
        
        
        a11=1;
%         classdist = zeros(data.classInfo.labelsCount,k);
%         classcum = zeros(data.classInfo.labelsCount,1);
%         for c=1:data.classInfo.labelsCount
%             for j=1:k-1
%                 sumc = sum(labelsIndex(proj < tr(j),c));
%                 classdist(c,j) =  sumc - classcum(c);
%                 classcum(c) = sumc;
%             end
%             classdist(c,k) = labelsPerClassCount(c) - classcum(c);
%         end
%         
        
        
    end
    
    return;
    nnn=nnn+1;

    % print('-depsc',sprintf('%d.eps',nnn));
    %%%%   Check if is PC and if not then learn another node 
    while (node.np(node.n) / node.nn(node.n)) < (1-epsilon)
        x2 =x(cl,:);
        y2 = y(cl);

        inew=find(cl == imax);
        %  inew=find(cl == ib(1));
        if inew == 0
            inew = [];
        end
        
        ww=2.0*rand(1,features)-1;
        [pc node2 ic2 cl2]=clusteroptimize(x2,y2,ww,'indGmax',inew,'plot','none','display','short');
        node.np = [node.np; node2.np ];
        node.nn = [node.nn; node2.nn ];
        node.npall = [ node.npall; node2.npall];
        node.all = [node.all; node2.all];
        node.n = 1 + node.n;
        
        figure(nnn);
        clf;
        bgraph3(x2*node2.w',y2,'borders',[node2.a node2.b]);
        print('-depsc',sprintf('%d.eps',nnn));
        nnn=nnn+1;
        
        node.a = [node.a; node2.a];
        node.b = [node.b; node2.b];
        node.w = [ node.w; node2.w ];
        ff = node.func;
        ff{node.n} = node2.func{1};
        node.func = ff;

%     z=node.n;
 %   fprintf('%2dth node (%d) %4.1f%% %5.3f [%s ] (%6.3f,%6.3f) +%d/%d -%d/%d %4.1f%%  %4.2f\n',k-1,node.label,0,pc,sprintf(' %6.3f',node.w(z,:)),node.a(z),node.b(z),node.np(z),node.npall(z),node.nn(z)-node.np(z),node.all(z)-node.npall(z),100*node.np(z)/node.all(z),node.np(z)/node.nn(z));  
        cl = cl(cl2);
%        disp(cl')
    end
    select=ones(vectorsCount,1);
    select(cl) = 0;
    ic = find(select);

    
    net{k}=node;
    k = k+ 1;    
    x = x(ic,:); 
    y = y(ic);

    labelsIndex=labelsIndex(ic,:);
    labelsPerClassCount=sum(labelsIndex,1);
    vectorsCount = length(ic);
    
    currnode = lastnode(x,y);
    currnode.n = 1;
    currnode.np = labelsPerClassCount(data.classInfo.labels == currnode.label);
    currnode.nn = vectorsCount;
    currnode.npall = currnode.np;
    currnode.all = vectorsCount;
    
    net{k}=currnode;
 
 %   fprintf('Cuurent network\n');
%    net{:}

    currtrainacc=nettest(data.x,data.y,net);
    
    if display > 0
            for z=1:node.n
                fprintf('%2dth node (%d) %4.1f%% %5.3f [%s ] (%6.3f,%6.3f) +%d/%d -%d/%d %4.1f%%  %4.2f\n',k-1,node.label,currtrainacc,pc,sprintf(' %6.3f',node.w(z,:)),node.a(z),node.b(z),node.np(z),node.npall(z),node.nn(z)-node.np(z),node.all(z)-node.npall(z),100*node.np(z)/node.all(z),node.np(z)/node.nn(z));
            end
    end
    % fprintf('Adding %dth node, accuracy %f \n',k-1,currtrainacc);
    
    if sum(labelsPerClassCount > 0) == 1
        break
    end

    if currtrainacc <= lasttrainacc
        net{k-1} = lnode;
        net=net(1:k-1);
%        fprintf('Removing bad neuron\n')
        break
    end
    lnode = currnode;
    lasttrainacc = currtrainacc;
end


 

trainacc=nettest(data.x,data.y,net);
%fprintf('Koncowa siec\n'); 
%net{:}

if display > 0
    fprintf(' Train acc. %6.2f\n',trainacc);
end

function node=lastnode(x,y)
    node.w=zeros(1,size(x,2));
    node.label = mode(y);
    node.a=-1;
    node.b=1;
    node.func{1}=@(x)ones(size(x,1),1);
        
        
function [parameters unmached]=qpcnet_config(varargin)

    param = inputParser;
    param.KeepUnmatched = true;
    % data
    % param.addRequired('x',@isnumeric);
    % param.addRequired('y',@isnumeric);
    param.addOptional('NetMethod','qpc2',@(x)any(strcmpi(x,{'qpc','qpc2'})));
    param.parse(varargin{:});
    parameters = param.Results;
    unmatched = param.Unmatched;
    unames=fieldnames(unmatched);
    clear param;

    if nargout  < 2 && size(unames,1) > 0
            error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
    end
    return;
