function prototypes=prototypes_init(x,y,k,method)
% P = PROTOTYPES_INIT(X,Y)
%                initialize prototypes positions for given data [X Y]
%
% PROTOTYPES_INIT(X,Y,K)  initialize K prototypes default K=number of labels) 
%               Posible K values:
%               0 < k < 1   - percentage of dataset/class
%               k >= 1       - overall number of prototypes
%               k = [ 1 2 .. nc] - number of prototypes for each class
%
% PROTOTYPES_INIT(X,Y,K,METHOD) 
%              Implemented METHODs  (default 'balanced')
%               'balanced' - balance class labels depend on size of classses
%               'fixed'      - fixed proportions
%               'means'      - put prototypes in class means (one per class)

if nargin < 4
    method = 'balanced';
end

nv=size(x,1);
ci=classstat(y);

if nargin < 3 || isempty(k) || (size(k,2) == 1 && k  < ci.labelsCount)
    k = ci.labelsCount;
    method = 'means';
end
if size(k,2) == 1  &&  k > nv
    k = nv;
end
if size(k,2) == ci.labelsCount;
    prototypesPerClassCount = k;
    ind = prototypesPerClassCount > ci.labelsPerClassCount;
    prototypesPerClassCount(ind) = ci.labelsPerClassCount(ind);
else
   switch method
        case 'balanced'
            if k > 0 && k < 1
                prototypesPerClassCount=ceil(ci.labelsPerClassCount.*k);
            else
               % [Y I]=sort(ci.labelsPerClassCount,'descend');
                prototypesPerClassCount=1+floor((k-ci.labelsCount)*ci.labelsPerClassCount./nv);
                rest=k-sum(prototypesPerClassCount);
%                prototypesPerClassCount(I(1:rest))=prototypesPerClassCount(I(1:rest))+1;
        
                while rest > 0  % reszte rozkladamy rownomiernie po klasach
                   ind = prototypesPerClassCount < ci.labelsPerClassCount;
                   prototypesPerClassCount(ind) = prototypesPerClassCount(ind) +1;
                   rest = rest - nnz(ind);
                end
            
            
            end
        case 'means'
                prototypes = means_init(x,ci) ;
                return;
        case 'fixed'
               if k > 0 && k < 1
                    k=ceil(k*nv);
                    if k < ci.labelsCount 
                        k = ci.labelsCount;
                    end
               end
       %        [Y I]=sort(ci.labelsPerClassCount,'descend');
                prototypesPerClassCount = 1+ones(1,ci.labelsCount).*floor((k-ci.labelsCount)/ci.labelsCount);
                ind = prototypesPerClassCount > ci.labelsPerClassCount;
                prototypesPerClassCount(ind) = ci.labelsPerClassCount(ind);

                rest=k-sum(prototypesPerClassCount);

                while rest > 0  % reszte rozkladamy rownomiernie po klasach
                   ind = prototypesPerClassCount < ci.labelsPerClassCount;
                   if nnz(ind) < rest
                       prototypesPerClassCount(ind) = prototypesPerClassCount(ind) +1;
                       rest = rest - nnz(ind);
                   else
                       ind = find(ind);
                       prototypesPerClassCount(ind(1:rest)) = prototypesPerClassCount(ind(1:rest)) +1;
                       rest = 0;
                   end
                end
                
            %    prototypesPerClassCount(I(1:rest))=prototypesPerClassCount(I(1:rest))+1;
            
        otherwise
            error(['Unknown option: ' method]);
    end
end
% disp(prototypesPerClassCount);
prototypes = random_init(x,y,ci,prototypesPerClassCount);

return ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function prototypes = random_init(x,y,ci,prototypesPerClassCount) 

nf=size(x,2);
prototypes = zeros(sum(prototypesPerClassCount),nf+1);

% position inicjalization
n=1;
for i=1:ci.labelsCount
    vid=randperm(ci.labelsPerClassCount(i));
    pc=prototypesPerClassCount(i);
    zz=x(y==ci.labels(i),:);
    for j=1:pc
        id=vid(j);
        prototypes(n,:)=[ zz(id,:) ci.labels(i)];
       n=n+1;
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function prototypes = means_init(x,ci) 

nf=size(x,2);
prototypes = zeros(ci.labelsCount,nf+1);

% position inicjalization
for i=1:ci.labelsCount
    prototypes(i,:)=[ mean(x(ci.labelsIndex{i},:),1) ci.labels(i)];
end

