function scaterplot(x,y,varargin)
% SCATERPLOT plots scatterplot
%
% SCATERPLOT(X,Y) scatterplot of two first dimensions of X with labels Y.
%
% SCATERPLOT(X,Y,FEATURES) scatterplots for all pairs of given FEATURES
% numbers
%
% SCATERPLOT(X,Y,OPTIONS)
%      Options:
%      'color'     : 'yes' or 'no'
%      'features'  : table of features indexes to plot (default [1 2] generate plot for first and secound feature)
%      'labels'    : cell table of string with labels in order acording to apearing in Y table (default 'off' - don't display labels)
%      'featurename' : cell array of features names (default '' - display feature number)
%      'title'     :
%      'str'       : cell of strings, add text to plot
%
%
param = inputParser;

param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);
param.addOptional('features',[1 2],@(x)isnumeric(x));
%param.addParamValue('position',[0.1 0.1 .8 .8],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('color','yes',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('labels','off');
param.addParamValue('featurename','');
param.addParamValue('title','');
param.addParamValue('str','');
param.addParamValue('select','no',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('borders','no',@(x)any(strcmpi(x,{'yes','no'})));
%param.addParamValue('align','left',@(x)any(strcmpi(x,{'left','right'})));
param.addOptional('diffussion',0,@(x)isnumeric(x) && x >= 0 );

param.parse(x,y,varargin{:});
parameters = param.Results;
clear param;

fig=gcf();
%clf;
set(fig,'Renderer','painters');

features=parameters.features;

color = 1;
if strcmp(parameters.color,'no')
    color = 0;
end

fname = '';
if ~strcmp(parameters.featurename,'')
    fname=parameters.featurename;
else 
    for i=1:length(features)
        fname{i}=sprintf('F%d',features(i));
    end
end

select = 0;
if strcmp(parameters.select,'yes')
    select = 1;
end

borders = 0;
if strcmp(parameters.borders,'yes')
    borders = 1;
end
diffussion = parameters.diffussion;

labels=unique(y);
labelsPerClassCount=size(labels,1);

set(gcf,'Color','w');

if color == 0
    lw =1;
    ms = 5;
    col = [0 0 0];
    mtype=['o+sd^'];
else
    col=[1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0.1 0.1 0.1];
    lw = 3;
    ms =3;
end

set(gcf,'DefaultAxesLineStyleOrder','o|+|s|d|^','DefaultAxesColorOrder',col);

labelsInd = cell(1,labelsPerClassCount);

for i=1:labelsPerClassCount
    labelsInd{i} = find(y == labels(i));
end

n = length(features)-1;
nplot = 1;
for k1=1:n
    f1 = features(k1);
    for k2=k1:n
        f2 = features(k2+1);
        px = cell(1,2*labelsPerClassCount);
        subplot(n,n,k1+n*(k2-1));
 %       cla;
        hold on;
        box on;
        %grid on;
        grid off;
%        set(gca,'Color',col);
        for i=1:labelsPerClassCount
            px{2*i-1} = x(labelsInd{i},f1);
            px{2*i} = x(labelsInd{i},f2);
            if diffussion > 0
                
%                disp(diffussion * randn(length(labelsInd{i}),1));
                px{2*i-1} = px{2*i-1} + diffussion * randn(length(labelsInd{i}),1);
                px{2*i} = px{2*i} + diffussion * randn(length(labelsInd{i}),1);
            end
        end

        ax=gca;
        if select == 0
            plot(ax,px{:},'LineWidth',lw,'MarkerSize',ms);
        else
%            hold on;

            xlim=get(ax,'XLim'); %xal = (xlim(2)-xlim(1))/2;
            ylim=get(ax,'Ylim'); %yal = (ylim(2)-ylim(1))/2;

            prCount=size(x,1);
            for pr=1:prCount;
                x1=x(pr,f1);
                y1=x(pr,f2);
                cl = find(y(pr)==labels);

                if color == 1
                    plot(ax,x1,y1,'o','MarkerFaceColor',col(cl,:),'MarkerEdgeColor','k','LineWidth',2,'MarkerSize',7);
                else
                    plot(ax,x1,y1,mtype(cl),'LineWidth',3,'MarkerSize',9);
                end
                
            end

            if borders == 1 && prCount > 2
                qwe=voronoi(ax,x(:,f1),x(:,f2),'-k');
                set(qwe,'MarkerSize',1);
            end
            if borders == 1 && prCount == 2
                w = x(2,[f1 f2])-x(1,[f1 f2]);
                w=w/norm(w);
                t= 0.5*(x(1,[f1 f2])+x(2,[f1 f2]));
                b=-t*w';
                if w(2)~=0
                    y=-(b+w(1).*xlim)./w(2);
                    plot(ax,xlim,y,'-k');
                end
            end

            set(ax,'XLim',xlim);
            set(ax,'Ylim',ylim);

            %plot(ax,px{:},'LineWidth',2,'MarkerSize',6,'MarkerFaceColor','k','Marker','s');
        end
        if k2 == n
            xlabel(fname{k1});
        end
        if k1 == 1
            ylabel(fname(k2+1));
        end

%        axis equal;
        hold off;
    end
    nplot = nplot +1;
end

if ~strcmp(parameters.labels,'off')
    labels = parameters.labels;
    legend(labels)
end


if ~strcmp(parameters.str,'')
     text(0.05,0.1,parameters.str,'units','normalized','HorizontalAlignment','left','visible','on');
end
if ~strcmp(parameters.title,'')
     title(parameters.title);
end
