%  skrypt generujacy wykresy (ICANN 08)
%  Dane : Parity10, Wine, circ4n2, Monk's 1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

method={'fda' , 'mds' , 'pca', 'qpc', 'svm'};
dataset={'diabetes' , 'heart' , 'leukemiaf100', 'monks1' , 'par8' , 'wisconsin'};
dirname='wykresy\';

%labels={'Class 1','Class 2'};

mc=size(method,2);
dc=size(dataset,2);

%labelsalign='center'; % 'right' 
%stralign='left';  % or 'right'
color='yes'; %or no
%sigma=0.1;
sigma=[];
title='';
s=[0.05 0.05 0.05 0.05 0.01 0.05; 0.5 0.5 5.0 0.3 0.2 0.3; 0.2 0.2 1.2 0.1 0.05 0.4; 0.1 0.1 0.05 0.1 0.01 0.05 ; 0.2 0.5 0.2 0.2 0.005 1.0 ];

for mi=1:mc
    for di=1:dc
        figure(1); clf;

        %title='Parity 10';


        f1=strcat(dirname,dataset{di},'_',method{mi},'_1.txt');
        f2=strcat(dirname,dataset{di},'_',method{mi},'_2.txt');
        
        o1=strcat(dirname,dataset{di},'_',method{mi},'_1.eps');
        o2=strcat(dirname,dataset{di},'_',method{mi},'_2.eps');
        
        % gestosci
        data=load(f1);
%        ah=bgraph3(data(:,1),data(:,end),'color',color,'sigma',sigma,'title',title);
        ah=bgraph4(data(:,1),data(:,end),'color',color,'sigma',s(mi,di),'title',title,'xlabel','w_1','plotPoints','no');
        print('-depsc',o1);

        %scaterplot
        data=load(f2);
        figure(2); clf;
        featurename={'w_1','w_2'};
        scaterplot(data(:,[1 2]),data(:,end),'title',title,'color',color,'featurename',featurename);
        print('-depsc',o2);
    end
end


return;


%str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*wp1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));


figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('I =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));

% Wine
figure(1); clf;
title='Wine';
labels={'Class 1','Class 2','Class 3'};
sigma=0.01;
w1=ww1;
w2=ww2;
i1=iw1;
i2=iw2;
data=normalize(wine);
labelsalign='center'; % 'right' 
stralign='left';  % or 'right'
filename='wine-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));


% Circ4n2
figure(1);
clf;
title='Concentric Rings';
labels={'Class 1','Class 2','Class 3','Class 4'};
sigma=0.01;
w1=wc1;
w2=wc2;
i1=ic1;
i2=ic2;
data=normalize(circ4n2);
labelsalign='right';
stralign='right';
filename='circ4n2-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));

% Monks1
figure(1); clf;
title='Monks 1';
labels={'Not a Monk','Is a Monk'};
sigma=0.01;
w1=wm1;
w2=wm2;
i1=im1;
i2=im2;
data=normalize(monks1);
labelsalign='center';
stralign='right';
filename='monks-fx4';

str={title,strcat('w =',sprintf(' %.2f ',w1)),strcat('QPC =',sprintf(' %.4f',i1))};
bgraph3(data(:,1:end-1)*w1',data(:,end),'sigma',sigma,'labels',labels,'str',str,'color',color,'labelsalign',labelsalign,'stralign',stralign);
print('-depsc',strcat(filename,'-ppi-col.eps'));

figure(2); clf;
featurename={strcat('w_2 = ',sprintf(' %.2f ',w2)),'w_1'};
str={strcat('QPC =',sprintf(' %.4f',i2)),strcat('w_1\cdot w_2 =',sprintf(' %.4f',w1*w2'))};
scaterplot([data(:,1:end-1)*w2' data(:,1:end-1)*w1'],data(:,end),'labels',labels,'str',str,'title',title,'color',color,'featurename',featurename);
print('-depsc',strcat(filename,'-ort-col.eps'));
