function ah=bgraph5(x,y,varargin)
% BGRAPH3 class distribution plot
%
% BGRAPH3(X,Y) plots estimated distribution of X with respect to class labels Y.  
%
% BGRAPH3(X,Y,SIGMA) value of SIGMA controls wildenes of gaussian functions used to estimate X
%    distribution. If not set then value of SIGMA is automatic choosen.
%
% BGRAPH3(X,Y,OPTIONS)
%    Options:
%          'sigma'    : value of SIGMA
%          'function' : handle to a function F(X) (e.g. @f_x4(X)) (default none)
%          'position' : [rectangle] look for PLOT options (default [0.1 0.1 .8 .8])
%          'color'    : 'yes' or 'no'
%          'labels'   : cell array of strings denoting class labels (default 'off')
%          'labelsalign' : 'center' or 'right' 
%          'str'      : cell array of strings (default '')
%          'stralign' : 'left' or 'right', align of displayed strings   (default 'left')
%          'title'    : plot title
%
% H = BGRAPH3(X,Y,OPTIONS) returns 1x2 table with handles to axes of
% created figure.

%   TODO
%   * find smarter and faster way for automatic estimating sigma value 

param = inputParser;

param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);
param.addOptional('sigma',[],@(x)isnumeric(x) && x>0);

% param.addOptional('function','f_x4',@(x)any(strcmpi(x,{'triangle','f_x4','bicentral'})));
% param.addOptional('beta',10, @(x)isnumeric(x) && x>0);
%param.addParamValue('position',[0.05 0.05 .9 .9],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('position',[0.1 0.1 .8 .8],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('function',[],@(x)isa(x,'function_handle'));
param.addParamValue('color','yes',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('labels','off');
param.addParamValue('labelsalign','center',@(x)any(strcmpi(x,{'center','right'})));
param.addParamValue('title','');
param.addParamValue('ylabel','');
param.addParamValue('str','');
param.addParamValue('stralign','left',@(x)any(strcmpi(x,{'left','right'})));
%param.addParamValue('center',[]);
param.addParamValue('borders',[]);

param.parse(x,y,varargin{:});

sig = param.Results.sigma;
pos = param.Results.position;
func = param.Results.function;
borders = param.Results.borders;

% w = pos(3);
% margin = 0.1;
% hbot = pos(4)/10;
% htop = pos(4) - margin - hbot;

data = [x y];

labels=unique(y);
labelsCount=size(labels,1);

% mind=min(data(:,1))-0.1;
% maxd=max(data(:,1))+0.1;
mind=min(data(:,1));
maxd=max(data(:,1));
range = maxd-mind;

if range == 0
    maxd =maxd + 1;
    mind = mind -1;
else
    maxd = maxd + 0.05*range;
    mind = mind - 0.05*range;
end
% msize = 2;
% psize = 4;

col=[1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0.1 0.1 0.1];

fig=gcf();

%clf;

set(fig,'Renderer','painters');
set(fig,'color','w','DefaultAxesColorOrder',col);
%set(fig,'color','w','DefaultAxesLineStyleOrder','--|-.');

% abot=axes('position',[pos(1) pos(2)             w hbot]);
%atop=axes('position',[pos(1) pos(2)+margin+hbot w htop]);
atop=get(fig,'currentaxes');

% hold(atop,'on');
% hold(abot,'on');

delta=(maxd-mind)/100;
xx=mind:delta:maxd;			% linear space

gauss=inline('(1/(sqrt(2*pi*sigma))) * exp(  -((x-m).^2)/(2*sigma)  )','m','sigma','x');

% set(atop,'xlim',[mind maxd]);
% set(abot,'xlim',[mind maxd],'ylim',[1 labelsCount]);
% set(abot,'visible','off');
% set(gcf(),'currentaxes',atop);

% if ~isempty(func)
%     axes(abot);
% %    area('v6',xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
%     area(xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
% end

pxc=zeros(labelsCount,length(xx));
pxp=cell(1,2*labelsCount);

dens=range/size(x,1);

for i=1:labelsCount
    labelsInd = find(y == labels(i));
  	nc1=length(labelsInd);
  	xc1=data(labelsInd,1);
  	%min1=min(xc1);
  	%max1=max(xc1);
  	ss=sort(xc1);
  	%std1=(max1-min1)/(2*nc1);
	if isempty(sig)
  	%	nstd1=0.2*max(ss(2:end)-ss(1:end-1));
     %   nstd1=10*dens;
        nstd1=std(x)*0.1;
	else 
		nstd1 = sig;
	end;
  	%pc1=nc1/n;

    for k=1:nc1
		pxc(i,:)=gauss(xc1(k),nstd1,xx)+pxc(i,:);
    end
    
    [a pmax(i)]=max(pxc(i,:));
    pxp{2*i-1}=xc1;
    pxp{2*i}=(ones(1,nc1)*i);
%    ticks(labelsCount-i+1)=pxp{2*i}(1);
end

% set(atop,'ytick',[],'ycolor','w');
% set(abot,'ytick',[],'ycolor','w');

% maxy=max(max(pxc));
% hi = 0.1*maxy;
% margin = 0.1*maxy;
% for k=2:2:2*labelsCount
%     pxp{k}=-pxp{k}*hi-margin;
% end

% set(abot,'YLim',[-.1 1.1]);

if strcmp(param.Results.color,'no') == 1
    msize = 1;
    psize = 2;
    set(atop,'ColorOrder',[0 0 0],'LineStyleOrder','-|--|-.|:');
%     set(abot,'ColorOrder',[0 0 0],'LineStyleOrder','o|d|s|v|^');
else
    msize = 2;
    psize = 3;
    set(atop,'ColorOrder',col,'LineStyleOrder','-');
%     set(abot,'ColorOrder',col,'LineStyleOrder','o');
end

% axes(atop);
plot(xx,pxc,'LineWidth',msize,'MarkerSize',psize); 
% set(atop,'ytick',[],'ycolor','w');
set(atop,'ytick',[]);
ylabel(param.Results.ylabel);

%text(atop,0.01,0.95,param.Results.str,'units','normalized');
%text(0.01,0.95,param.Results.str,'units','normalized');
%pos=[-0.12 1.3];
if strcmp(param.Results.stralign,'left')
    pos=[0 1];
    text(pos(1),pos(2),param.Results.str,'units','normalized','HorizontalAlignment','left','visible','on');
else
    pos=[1 1];
    text(pos(1),pos(2),param.Results.str,'units','normalized','HorizontalAlignment','right','visible','on');
end
if ~strcmp(param.Results.title,'')
     title(param.Results.title);
end

mm=get(gca,'YLim');
% if ~isempty(center)
%     plot([projection(igmax) projection(igmax)],[mm(1) G(igmax)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
% end

if ~isempty(borders)
    plot([ borders(1) borders(1)],[mm(1) mm(2)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
    plot([ borders(2) borders(2)],[mm(1) mm(2)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
end


% axes(abot);
%xlabel(param.Results.str{1})

% plot(pxp{:},'MarkerSize',psize,'LineWidth',msize); 
% ylim('auto');


%plot(pxp{:},'MarkerSize',psize,'MarkerFaceColor',[.7 .7 .7]); 
%plot(xx,pxc1,strcat('o',colors(i)),'markersize',3,'MarkerFaceColor',colors(i)); 
%xlabel(sprintf('s=%0.2f r=%0.2f',nstd1,range));

% 
% if ~strcmp(param.Results.labels,'off')
%     axes(abot);
%     
%     for i=1:labelsCount
%         if strcmp(param.Results.labelsalign,'center')
%             text(xx(pmax(i)),pxp{2*i}(1)+0.1,param.Results.labels{i},'HorizontalAlignment','center','VerticalAlignment','bottom','margin',100);
%         end
%         if strcmp(param.Results.labelsalign,'right')
%             text(max(pxp{2*i-1}+0.05),pxp{2*i}(1),param.Results.labels{i},'HorizontalAlignment','left','VerticalAlignment','middle','margin',100);
%         end
%         
%     %    axes(atop)
% %    legend(param.Results.labels,'location','northeast');
% %    legend('boxoff');
%     end
% end

%xlabel(abot,'Projection on');
% ah = [atop ; abot];
ah=atop;
% hold(atop,'off');
% hold(abot,'off')

