function ci=classstat(y)
% returns structure CI whit basic statisctics of caterogical feature Y (eg.
% class labels)
%
% ci.labelsCount - number of categories
% ci.labelsIndex - binary matrix, category maping, 1-per-class
% ci.labels - labels values
% ci.labelsPerClassCount - number of values per category (label)

[labels a index] = unique(y);

ci.labelsCount = size(labels,1);
ci.labelsIndex = zeros(length(y),ci.labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

for i=1:ci.labelsCount
    ci.labelsIndex(:,i) = (index == i);
end

ci.labels=labels';
ci.labelsPerClassCount=sum(ci.labelsIndex);
