function ah=bgraph3(x,y,varargin)
% BGRAPH3 class distribution plot 

ah=bgraph(x,y,varargin{:});
return;

% plik na potrzeby zgodnosci z poprzednimi wersjami





%
% BGRAPH3(X,Y) plots estimated distribution of X with respect to class labels Y.  
%
% BGRAPH3(X,Y,SIGMA) value of SIGMA controls wildenes of gaussian functions used to estimate X
%    distribution. If not set then value of SIGMA is automatic choosen.
%
% BGRAPH3(X,Y,OPTIONS)
%    Options:
%          'sigma'    : value of SIGMA
%          'function' : handle to a function F(X) (e.g. @f_x4(X)) (default none)
%          'position' : [rectangle] look for PLOT options (default [0.1 0.1 .8 .8])
%          'color'    : 'yes' or 'no'
%          'labels'   : cell array of strings denoting class labels (default 'off')
%          'labelsalign' : 'center' or 'right' 
%          'str'      : cell array of strings (default '')
%          'stralign' : 'left' or 'right', align of displayed strings   (default 'left')
%          'title'    : plot title
%          'points'   : 'yes' or 'no', draw class-points at the bottom
%          (default 'yes')
%          'select'   ; 'yes' or 'no', select prototypes on existing (!!!)
%          bgraph plot, note that this add some info on existing active
%          plot
%
% H = BGRAPH3(X,Y,OPTIONS) returns 1x2 table with handles to axes of
% created figure.

%   TODO
%   * find smarter and faster way for automatic estimating sigma value 
%   * selected - how to ake it simpler

param = inputParser;

param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);
param.addOptional('sigma',[],@(x)isnumeric(x) && x>0);

% param.addOptional('function','f_x4',@(x)any(strcmpi(x,{'triangle','f_x4','bicentral'})));
% param.addOptional('beta',10, @(x)isnumeric(x) && x>0);
%param.addParamValue('position',[0.05 0.05 .9 .9],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('position',[0.1 0.1 .8 .8],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('function',[],@(x)isa(x,'function_handle'));
param.addParamValue('color','yes',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('labels','off');
param.addParamValue('labelsalign','center',@(x)any(strcmpi(x,{'center','right'})));
param.addParamValue('title','');
param.addParamValue('ylabel','');
param.addParamValue('str','');
param.addParamValue('stralign','left',@(x)any(strcmpi(x,{'left','right'})));
%param.addParamValue('center',[]);
%param.addParamValue('borders',[]);
param.addParamValue('select','no',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('borders','no',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('points','yes',@(x)any(strcmpi(x,{'yes','no'})));  % show bottom plot with points

param.parse(x,y,varargin{:});

sig = param.Results.sigma;
pos = param.Results.position;
func = param.Results.function;
%borders = param.Results.borders;
pointsView = 1;
if strcmp(param.Results.points,'no')
    pointsView = 0;
end
select = 0;
if strcmp(param.Results.select,'yes')
    select = 1;
end

w = pos(3);
margin = 0.1;
hbot = pos(4)/10;
htop = pos(4) - margin - hbot;

data = [x y];

cstat = classstat(y);

mind=min(data(:,1))-0.1;
maxd=max(data(:,1))+0.1;

%msize = 2;
%psize = 4;

col=[1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0.1 0.1 0.1];
mtype=['o','s','+','d','v','^'];
fig=gcf();

abot = [];
atop = [] ; %  get(fig,'currentaxes')

if select == 0
    
    delta=(maxd-mind)/100;
    xx=mind:delta:maxd;			% linear space

    gauss=inline('(1/(sqrt(2*pi*sigma))) * exp(  -((x-m).^2)/(2*sigma)  )','m','sigma','x');


    pxc=zeros(cstat.labelsCount,length(xx));
    pxp=cell(1,2*cstat.labelsCount);

    pmax = zeros(1,cstat.labelsCount);
    
    for i=1:cstat.labelsCount
        nc1 = cstat.labelsPerClassCount(i);
        xc1 = data(cstat.labelsIndex(:,i) == 1,1);
        %min1=min(xc1);
        %max1=max(xc1);
        ss=sort(xc1);
        %std1=(max1-min1)/(2*nc1);
        if isempty(sig)
%            nstd1=0.2*max(ss(2:end)-ss(1:end-1));
            nstd1=std(x)*0.1;
        else 
            nstd1 = sig;
        end;

        for k=1:nc1
            pxc(i,:)=gauss(xc1(k),nstd1,xx)+pxc(i,:);
        end

        [a pmax(i)]=max(pxc(i,:));
        pxp{2*i-1}=xc1;
        pxp{2*i}=(ones(1,nc1)*i);
    %    ticks(labelsPerClassCount-i+1)=pxp{2*i}(1);
    end

        
    
    %clf;   %   plotting
    set(fig,'Renderer','painters');
    set(fig,'color','w','DefaultAxesColorOrder',col);
    %set(fig,'color','w','DefaultAxesLineStyleOrder','--|-.');

    if pointsView == 1
        abot=axes('position',[pos(1) pos(2)             w hbot]);
        atop=axes('position',[pos(1) pos(2)+margin+hbot w htop]);
  
        hold(abot,'on');
        set(abot,'xlim',[mind maxd],'ylim',[1 cstat.labelsCount]);
        set(abot,'visible','off');
        set(abot,'ytick',[],'ycolor','w');
        set(abot,'YLim',[-.1 1.1]);
    else
        atop=axes;
    end
    hold(atop,'on');
    set(atop,'xlim',[mind maxd]);
    set(atop,'ytick',[],'ycolor','w');
    set(gcf(),'currentaxes',atop);
    
    if strcmp(param.Results.color,'no') == 1
        msize = 1;
        psize = 2;
        set(atop,'ColorOrder',[0 0 0],'LineStyleOrder','-|--|-.|:');
        set(abot,'ColorOrder',[0 0 0],'LineStyleOrder','o|s|+|d|v|^');
    else
        msize = 2;
        psize = 3;
        set(atop,'ColorOrder',col,'LineStyleOrder','-');
        set(abot,'ColorOrder',col,'LineStyleOrder','o');
    end

    axes(atop);
    plot(xx,pxc,'LineWidth',msize,'MarkerSize',psize); 
    ylabel(param.Results.ylabel);
    drawnow;
    %text(atop,0.01,0.95,param.Results.str,'units','normalized');
    %text(0.01,0.95,param.Results.str,'units','normalized');
    %pos=[-0.12 1.3];
    if strcmp(param.Results.stralign,'left')
        pos=[0 1];
        text(pos(1),pos(2),param.Results.str,'units','normalized','HorizontalAlignment','left','visible','on');
    else
        pos=[1 1];
        text(pos(1),pos(2),param.Results.str,'units','normalized','HorizontalAlignment','right','visible','on');
    end
    if ~strcmp(param.Results.title,'')
         title(param.Results.title);
    end

    
    
    % mm=get(gca,'YLim');
    % if ~isempty(center)
    %     plot([projection(igmax) projection(igmax)],[mm(1) G(igmax)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
    % end

%     if ~isempty(borders)
%         plot([ borders(1) borders(1)],[mm(1) mm(2)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
%         plot([ borders(2) borders(2)],[mm(1) mm(2)],'k--','MarkerSize',psize+1,'LineWidth',msize+1); 
%     end


    if pointsView == 1
        axes(abot);
        %xlabel(param.Results.str{1})

        plot(pxp{:},'MarkerSize',psize,'LineWidth',msize); 
        ylim('auto');


        if ~isempty(func)
            axes(abot);
        %    area('v6',xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
            area(xx,0.9*func(xx-(maxd+mind)/2),'edgecolor','none','facecolor',[0.8 0.95 0.4]);
        end

        %plot(pxp{:},'MarkerSize',psize,'MarkerFaceColor',[.7 .7 .7]); 
        %plot(xx,pxc1,strcat('o',colors(i)),'markersize',3,'MarkerFaceColor',colors(i)); 

        if ~strcmp(param.Results.labels,'off')
            axes(abot);

            for i=1:cstat.labelsCount
                if strcmp(param.Results.labelsalign,'center')
                    text(xx(pmax(i)),pxp{2*i}(1)+0.1,param.Results.labels{i},'HorizontalAlignment','center','VerticalAlignment','bottom','margin',100);
                end
                if strcmp(param.Results.labelsalign,'right')
                    text(max(pxp{2*i-1}+0.05),pxp{2*i}(1),param.Results.labels{i},'HorizontalAlignment','left','VerticalAlignment','middle','margin',100);
                end

            %    axes(atop)
        %    legend(param.Results.labels,'location','northeast');
        %    legend('boxoff');
            end
        end
    end
else
    ah=get(fig,'Children');
    atop=ah(2);
    abot=ah(1);
    axes(abot);
    hold on;
    pv=size(x,1);
    for pr=1:pv
        y1= y(pr)==cstat.labels;
        kolor = col(y1,:);
        
        if strcmp(param.Results.color,'yes') == 1
            plot(abot,x(pr),find(y1),'o','MarkerFaceColor',kolor,'MarkerEdgeColor','k','LineWidth',2,'MarkerSize',7);
        else
            plot(abot,x(pr),find(y1),mtype(y1),'MarkerSize',8,'LineWidth',3);
        end


    end

    if strcmp(param.Results.borders,'yes')
        [sx ti] = sort(x);
        sy=y(ti);
        xn=length(x);
        for bi=1:xn-1
            if sy(bi) ~= sy(bi+1)
                t=(sx(bi)+sx(bi+1))/2;
%                 axes(abot);
%                 yl1 = get(gca,'YLim');
%                 plot([t t],yl1,'-k');
                axes(atop);
                hold on;
                yl1 = get(gca,'YLim');
                plot([t t],yl1,'-k');

            end
        end
        
    end
%             if borders == 1 && pr == 2
%                 w = x(2,[f1 f2])-x(1,[f1 f2]);
%                 w=w/norm(w);
%                 t= 0.5*(x(1,[f1 f2])+x(2,[f1 f2]));
%                 b=-t*w';
%                  y1=-(b+w(1)*xlim(1))/w(2);
%                  y2=-(b+w(1)*xlim(2))/w(2);
% %                y1=-(b+w(1)*(-300))/w(2);
% %                y2=-(b+w(1)*50)/w(2);
%                 plot(ax,xlim,[y1 y2],'-k');
%             end

end

if pointsView == 1 
    ah = [atop ; abot];
    hold(abot,'off')
else
    ah = atop;
end
hold(atop,'off');
