function net=mlptrain(x,y,n,lr,maxiter,eps)

% MLPTRAIN 
%     skrypt pomocniczy do tworzenia MLP (uzywa NNToolbox)

if nargin < 6; eps = 0.001 ; end
if nargin < 5; maxiter = 1000 ; end
if nargin < 4; lr = 0.1 ; end
if nargin < 3; n = 10; end

cl=classstat(y);

if cl.labelsCount > 2
    yy = [cl.labelsIndex{:}];
    outputs = cl.labelsCount;
else
    yy = cl.labelsIndex{1};
    outputs = 1;
end
nodetype = 'logsig'; % logsig, tansig, purelin

if verLessThan('matlab', '7.5')
    if n == 0
        net1=newff(minmax(x'),outputs,{nodetype});
    else 
        net1=newff(minmax(x'),[n outputs],{nodetype nodetype});
    end
else
    net1=newff(x',yy',{nodetype});
end

net.nodetype=nodetype;
net.classtats=cl;
net1.trainParam.show=NaN;
net1.trainParam.epochs=maxiter;
net1.trainParam.lr=lr;
net1.trainParam.goal=eps;
net.net=train(net1,x',yy');
net.nw=n;
net.np=outputs;
net.trainacc=mlptest(x,y,net);
