function prototypes=lvqtrain(x,y,k,learningRate)
% LVQ learning with K prototypes and given initial LEARNINGRATE

[nv nf]=size(x);

[labels a index] = unique(y);
labelsCount = size(labels,1);
lrate=ones(1,k)*learningRate;
eps = 0.01;
%labelsIndex = zeros(vectorsCount,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

if nargin < 3 || k < labelsCount; k =labelsCount; end
if nargin < 4 ; learningRate = 0.1 ;end

prototypes = zeros(k,nf+1);
maxIterations = 1000;

labelsIndex = zeros(nv,labelsCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0

for i=1:labelsCount
    labelsIndex(:,i) = (index == i);
end
labelsPerClassCount=sum(labelsIndex);
[Y I]=sort(labelsPerClassCount,'descend');
prototypesCount=1+floor((k-labelsCount)*labelsPerClassCount./nv);

rest=k-sum(prototypesCount);
for i=1:rest
    prototypesCount(I(i))=prototypesCount(I(i))+1;
end

% dopisac inicjalizacje prototypow
% puki co - losowo

n=1;
for i=1:labelsCount
    vid=randperm(labelsPerClassCount(i));
    pc=prototypesCount(i);
    zz=x(y==labels(i),:);
    for j=1:pc
        id=vid(j);
        prototypes(n,:)=[ zz(id,:) labels(i)];
%        prototypes(n,end)=labels(i);
%       prototypes(n,:)=[ rand(1,nf)*2-1 labels(i)];
        n=n+1;
    end
end

px = prototypes(:,1:end-1);
py = prototypes(:,end);

stop = 0;
n=1;

f=[1:3];


%         scaterplot(x,y,f);
%         hold on;
%         scaterplot(px,py,f,'select','yes');
%         drawnow;
%         hold off;

        lvqerr= [];

        distance=@(x,y)dEuclid(x,y);

while stop == 0
    id = randperm(nv);
    
    for i=1:nv
        [pid S]=lvq1([px py],x(id(i),:),y(id(i)),distance);
        lr=lrate(pid);
        px(pid,:)=px(pid,:)+S*lr*(x(id(i),:)-px(pid,:));
        lrate(pid)=lr/(1+S*lr);
        if lrate(pid) > 1; lrate(pid)=1; end
        
%           lvqerr(n)=lvqerror(x,y,[px py]);
%           fprintf('ep %3d Elvq %6.4f lr %s\n',n,lvqerr(n),sprintf(' %.4f',lrate));
%          px(PI,:)=px(PI,:)+S*learningRate*(x(id(i),:)-px(PI,:));
    
%         clf;
%         scaterplot(x,y,[f1 f2]);
%         hold on;
%         scaterplot(px,py,[f1 f2],'select','yes');
%         drawnow;
%         hold off;


    end

%         clf;
%         scaterplot(x,y,f);
%         hold on;
%         scaterplot(px,py,f,'select','yes');
%         drawnow;
%         hold off;

%    learningRate=learningRate*0.9;
   lvqerr(n)=lvqerror(x,y,[px py]);
   fprintf('ep %3d Elvq %6.4f lr %s\n',n,lvqerr(n),sprintf(' %.2f',lrate));
%   fprintf('ep %3d Elvq %6.4f lr %4.3f\n',n,lvqerr(n),learningRate);
%pause;
    
    if n>= maxIterations || norm(lrate)<eps; 
        stop =1 ;
    end
    n=n+1;
end


