function [net trainacc]=lvqnetwork(x,y,lvqlr,k,init,epsilon)
% siec LVQ

if nargin < 3; lvqlr = 0.05; end %learningRate
if nargin < 4; k = 5; end % number of prototypes 
if nargin < 5; init = 5; end % number of initiations
if nargin < 6; epsilon = 0.001; end

bestp=[];
besterr=1;

for i=1:init
    p=llvqtrain(x,y,'k',k,'lvqlr',lvqlr,'linear','no','eps',epsilon);
    err=lvqerror(x,y,p);
    if err < besterr
        bestp = p;
        besterr = err;
    end
end
trainacc = 100*(1-besterr);
net.w=[];
net.nw=0;
net.p=bestp;
net.np=size(bestp,1);
%net.param = net.w*((size(x,2)-1) + net.p);
net.trainacc = trainacc;
