function [parameters unmatched]=lvq_config(varargin)
% TODO - write help here

param = inputParser;
param.KeepUnmatched = true;

% LVQ training
param.addOptional('k',0,@(x)isnumeric(x) );
param.addOptional('lvqlr',0.05,@(x)isnumeric(x));
param.addOptional('initp',[],@(x)isnumeric(x));
param.addParamValue('maxlrate',0.5,@(x)numeric && x>0);
param.addParamValue('dead','transfer',@(x)any(strcmpi(x,{'leave','transfer','remove'})));
param.addParamValue('eps',0.001,@(x)isnumeric(x) && x>0);
param.addParamValue('maxiterations',[],@(x)isnumeric(x));
param.addParamValue('MaxEpochs',100,@(x)isnumeric(x));
param.addParamValue('Metric',@(x,y)dEuclid(x,y),@(x)(isa(x,'function_handle') || any(strcmpi(x,{'euclid'}))));
%param.addParamValue('initiations',5,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('checkPeriod',3,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('maxtun',10,@(x)isnumeric(x) && x>0 && mod(x,1)==0);  % max. liczba przenoszonych martwych prototypow
%param.addParamValue('stopCriterium',2,@(x)x==1|| x==2);

% loging
param.addParamValue('log','off',@(x)any(strcmpi(x,{'on','off'})));
param.addParamValue('logFile',[],@ischar);
param.addParamValue('dataName','data',@ischar);
param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
param.addParamValue('savedir',[],@ischar);
param.addParamValue('display',0,@(x)((isnumeric(x)&& x >= 0) || any(strcmpi(x,{'none','all','short'}))));

% plotting
%param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));
%
param.parse(varargin{:});
%disp(param.Results);
parameters = param.Results;
unmatched = param.Unmatched;
unames=fieldnames(unmatched);
clear param;

if isa(parameters.display,'char') == 1
    switch parameters.display
        case 'none'
            parameters.display = 0;
        case 'short'
            parameters.display = 1;
        case 'all';
            parameters.display = 2;
        otherwise
            parameters.display = 0;
    end
end

if isa(parameters.Metric,'char')
    switch parameters.Metric
        case 'euclid'
            Metric=@(x,y)dEuclid(x,y);
        otherwise
            Metric=@(x,y)dEuclid(x,y);
    end

    parameters.Metric = Metric;
 end



if nargout  < 2 && size(unames,1) > 0
        error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
end