function [prototypes acc lrate]=lvq(x,y,varargin)
% lerning LVQ 
% Refer to "help lvq_config" for more details.
%
% TODO
% 1. poprawic transfer/usuwanie martwych prototypow - czy warto umieszczac to
% w tym pliku, moze lepiej aby metody kozystajace z LVQ robily to same
% 2. dodac opis opcji
% 3. Dlaczego gdzu metryka jest dana w paramertach config.Metric jak string to uczenie trwa ok 10 razy dluzej?
% Niewyjasniona zagadka?!
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

config = lvq_config(varargin{:});
if config.display > 0 
    disp('Configuration:');
    disp(config);
end

% LVQ parameters
maxlrate = config.maxlrate;

%maxiterations = config.maxiterations;
%initiations = param.Results.initiations;
avgtest       = config.checkPeriod;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nv=size(x,1);

% prototypes initialization 
if isempty(config.initp)
    prototypes = prototypes_init(x,y,config.k,'balanced');
else
    prototypes=config.initp;
end

k=size(prototypes,1);
if length(config.lvqlr)==k
    lrate = config.lvqlr;
else
    lrate=ones(1,k)*config.lvqlr;
end

px = prototypes(:,1:end-1);
py = prototypes(:,end);

epocherr = zeros(1,config.MaxEpochs);
epoch = 1;
epocherr0=lvqerror(x,y,[px py],config.Metric);

if config.display > 1
    fprintf('ep %-4d error %6.4f\n',0,epocherr0); 
end


cfr = 1;

%distance=@(x,y)dEuclid(x,y);

stop = false;
while stop == false
    id = randperm(nv);
   %id = 1:nv;   
    for ni=1:nv   
        % LVQ1 
     %   [pid S]=lvq1([px py],x(id(ni),:),y(id(ni)),config.Metric);
                [pid S]=lvq1([px py],x(id(ni),:),y(id(ni)),config.Metric);

         ll=S.*lrate(pid);
         px(pid,:)=px(pid,:)+cfr*ll.*(x(id(ni),:)-px(pid,:));
         lrate(pid)=lrate(pid)./(1+ll);

        if lrate(pid) > maxlrate; lrate(pid)=maxlrate; end
    end
 
    [error pn]=lvqerror(x,y,[px py],config.Metric);
    epocherr(epoch)=error;

    if config.display > 1
        fprintf('ep %-4d error %6.4f\n',epoch,epocherr(epoch)); 
    end

    %      clf;
    %      w=ones(1,size(x,2));
    %      bgraph3(x*w',y);
    %      bgraph3(px*w',py,'select','yes');
    %      scaterplot(x,y,'features',1:4);
    %      scaterplot(px,py,'select','yes','features',1:4);
    %      plot(0:epoch,[epocherr0 epocherr(1:epoch)]);
    %      drawnow;


    % what to do whith redundand prototypes ?
    [px py lrate]=remove_redundancy(x,y,pn,px,py,lrate,config);

    if epoch >= avgtest
        lasterrtab=epocherr(epoch-avgtest+1:epoch);
%         avgerr = mean(lasterrtab);
          
%        if (abs((avgerr - lastavgerr)/lastavgerr) < eps || std(lasterrtab))<eps && ne > 1  
        if std(lasterrtab)<eps 
            stop = 1;
            if config.display > 1
               fprintf('STOP: Error does not change to much\n');
            end
        end;
    end;

    if epoch>= config.MaxEpochs
        stop = true ;
        if config.display > 1
            fprintf('STOP: Max Epochs (%d) reached\n',config.MaxEpochs);
        end
    end
    if norm(lrate) < config.eps 
        stop = true;
        if config.display > 1
            fprintf('STOP: LVQ learning rate drops to much\n');
        end
    end
    epoch=epoch+1;
end
acc=1-epocherr(epoch-1);
prototypes=[px py];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [px py lrate]=remove_redundancy(x,y,pn,px,py,lrate,config)

tun = zeros(1,size(px,1));
deadp = pn(:,1)+pn(:,2) == 0;  % dead prototypes (to far from data)

ndead=nnz(deadp);
if ndead == 0
    return
end

switch config.dead
    case 'remove'
        px=px(~deadp,:);
        py=py(~deadp);
        lrate=lrate(~deadp);
        if config.display > 1
            fprintf('Remove %d dead prototypes\n',ndead); 
        end

    case 'transfer'
         if nnz(deadp) > 0
             tunrem=tun>config.maxtun;
             if nnz(tunrem) > 0 && nnz(tunrem) < size(px,1)
                 % usuwamy te ktore za duzo razy tunelowaly
%                     px=px(~tunrem,:);
%                     py=py(~tunrem);
%                     lrate=lrate(~tunrem);
%                     fprintf('Removing %d prototypes (tuneling to many times)\n',nnz(tunrem));
%                     deadp=deadp(~tunrem);
%                     tun=zeros(1,nnz(~tunrem));
%                     k=k-1;
                 fprintf('Warning: Dead prototypes removing not allowed\n');
             end

             tun(deadp)=tun(deadp)+1;
             px=trnsfer(x,y,[px py],deadp);
             lrate(deadp)=config.lvqlr./tun(deadp);
       %     fprintf('ep %3d Elvq %6.4f Ellvq %6.4f Elin %6.4f [ ',ne,lvqerr(ne),llvqerr,lerr);
           if config.display > 1
                lvqerr2=lvqerror(x,y,[px py],config.Metric);
                fprintf('TUNELING error %6.4f\n',lvqerr2); 
           end
        end
end

return;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function newpx=trnsfer(x,y,p,dead)

nv=size(x,1);
%np=size(p,1);
distance=@(x,y)dEuclid(x,y);
%rest=nnz(dead);
didx=find(dead);

for di=didx'
    cc = p(di,end);
    id = randperm(nv);    
    for i=1:nv
        if y(id(i))== cc
            [I S]=lvq1(p,x(id(i),:),y(id(i)),distance);
            if S == -1
                p(di,1:end-1)=x(id(i),:);
                break;
            end
        end
    end
end
newpx=p(:,1:end-1);

return;
