function [p w err]=llvqtrain2(x,y,prototypes,k,lvqlr,attempts,llr)
% najpierw LVQ - potem rzut na prosta QPC, i potem douczanie LVQ i rzut na
% prosta itd. ATTEMPTS razy

if nargin < 4
    k = 1;
end

if nargin < 5
    lvqlr = 0.05;
end
if nargin < 6
    attempts = 5;
end
if nargin < 7
    llr = 1;
end

if nargin < 3 || isempty(prototypes)
      prototypes=llvqtrain(x,y,k,'lvqlr',lvqlr,'linear','no');
end

px = prototypes(:,1:end-1);
py = prototypes(:,end);

for i=1:attempts
    if i > 1
        [p2 w2 err2]=llvqtrain(x,y,'lvqlr',lvqlr/i,'initp',[px py],'linear','no');
        px=p2(:,1:end-1);
    end
    
    [dislocation err w]=linearization3(x,y,px,py);
    px=px-llr*dislocation;
end
p=[px py];
err = lvqerror(x*w',y,[px*w' py]);