function [wp dislocation err]=linearization_qpc(x,y,px,py,wi,parameters)
% FUNCTION [W D E]=LINEARIZATION_QPC(X,Y)
% QPC based linearization
% direction fitting using supervised QPC indeks
% If prototypes are not given then learning is performed on entire dataset O(n^2). 
% W - direction
% D - disslocation, shifr from origin centre ( Y=WX-D ??)
% E - squer euclidean error 
%
% [W D E]=LINEARIZATION_QPC(X,Y,PARAM)
% PARAM - parameters struct (obtigned from QPC_OPTION_PARSER())
% If PARAM is not given then: initiations=2, maxIterations=100 and no display
% and no plots. All datasets (no prototype) is used.
%
% [W D E]=LINEARIZATION_QPC(X,Y,PX,PY)
% QPC learning with prototypes [PX PY]
%
% [W D E]=LINEARIZATION_QPC(X,Y,PX,PY,PARAM)
% QPC learning with prototypes [PX PY] and given PARAM parameters. Note
% that PARAM.prototypes will be overriden by [PX PY]
% If PARAM is not given then: initiations=5, maxIterations=200 and no display
% and no plots.
%
% [W D E]=LINEARIZATION_QPC(X,Y,PX,PY,WI)
% [W D E]=LINEARIZATION_QPC(X,Y,PX,PY,WI,PARAM)
% QPC learning with prototypes [PX PY] and given init weights WI and PARAM parameters. Note

% QPC learning with prototypes [PX PY] and given PARAM parameters. Note

fprintf('DZIALAM\n');

if nargin == 6
    parameters.prototypes = [px py];
    parameters.initWeights = wi;
else
    parameters = [];
end
if nargin == 3 && isa(px,'struct')
        parameters = px;
end
if nargin == 5 && isa(wi,'struct')
        parameters = wi;
        parameters.prototypes = [px py];
end
if nargin < 6;   
    init = 5;   
    maxiter = 200; 
end
if nargin < 5 ;    wi = []; end
    
if nargin < 3 && isempty(parameters)
    init = 2; % chyba lepiej zwiekszyc - gdyz jest multistart
    wi = [];
    maxiter = 100;
    px = [];
    py = [];
end
   
if isempty(parameters)
    parameters=qpc_config('initWeights',wi,'prototypes',[px py],'initiations',init,'directions',1,'display','none','plot','none','maxIterations',maxiter);
end


wp=qpc_1d(x,y,parameters);


if nargout > 1
    if isempty(parameters.prototypes)
        mx=mean(x);
        nv=size(x,1);
        c=x-ones(nv,1)*mx;              % data centering x-mean(x)
    else
        nv=size(parameters.prototypes,1);
        mx=mean(parameters.prototypes(:,1:end-1));
        c=px-ones(nv,1)*mx;              % data centering x-mean(x)
    end
    p=c*wp'*wp;         
    dislocation = c-p;   
end
if nargout > 2
    err = sum(sum((c-p)'.^2))/nv;
end


