function icann09compMLP(train,known,blind)

init=1;
ccoeff=0.67:-0.001:0.64;

savedir = strcat(datestr(now,'yy.mm.dd'),'.ICANN09comp/');
[s comment] = mkdir(savedir);
if s == 0
     error(comment);
end
method='ccMLP';
logfilename=strcat(savedir,datestr(now,'yy.mm.dd-[HH.MM.SS].'),method,'.cv.log');
logfile = fopen(logfilename,'wt');

[trainx trans]=normalize(train(:,1:end-1));
trainy=train(:,end);

knownx=normalize(known(:,1:end-1),trans);
knowny=known(:,end);

blindx1=normalize(blind,trans);

lr=0.1;
maxIter=1000;
eps=0.001;
nn =1;

for cc=ccoeff
    corrcc = corr_feat_sel(trainx,trainy);
    ccid=find(corrcc >= cc);
    nf=length(ccid);
    x=trainx(:,ccid);
    y=trainy;
   
    testdata=knownx(:,ccid);
    testy=knowny;
    
    blindx=blindx1(:,ccid);
    
    for i=1:init
           net = mlptrain_reg(x,y,nn,lr,maxIter,eps);
           [mser knownout] = mlptest_reg(testdata,testy,net);
           fprintf('init %2d known %6.3f train %6.3f feat %3d cc=%6.3f\n',i,mser,net.trainmse,nf,cc);
           fprintf(logfile,'init %2d known MSE=%6.3f train %6.3f feat %3d cc=%6.3f\n',i,mser,net.trainmse,nf,cc);

           blindout=sim(net.net,blindx');
           filename1=strcat(savedir,sprintf('cc_%f_nf_%d_known.txt',cc,nf));
           filename2=strcat(savedir,sprintf('cc_%f_nf_%d_blind.txt',cc,nf));
           savedata(filename1,knownout);
           savedata(filename2,blindout');
    end
end

fclose(logfile);

return;


function savedata(name,output)

    f = fopen(name,'wt');
    no=size(output,1);
    for i=1:no
        fprintf(f,'mol_%d\t%f\n',i,output(i)');
    end

    fclose(f);

