function [ppi node ic cl] = clusteroptimize(x,y,w,varargin)
%    PPI = CLUSTERFIND(X,Y,W,OPTIONS) looking for best PPI value in respect to W and T,
%            where T is a center of cluster, initially T=X(I) and T is
%            associated with class Y(I)
%
%    OPTIONS same as QPC_CONFIG and 
%           'ClusterMethod' : 'mse' (default) or 'qpc'
%                             'mse' optimize neuron with MSE (with penalty term) and gradient descent               
%                             'qpc' optimize partial QPC (Q(x)) in the centre G(x(igmax)) 
%
%    OPTIONS for MSE 
%            'labels'  
%            'tresholds'
%             Note: it is umportant to  use correct 'function'. 


if nargin < 3; error('Error while parser options.'); end;
[qpc_parameters unmached] = qpc_config(varargin{:});
parameters = clusteroptimize_config(unmached);

is_mse = strcmp(parameters.ClusterMethod,'mse') == 1;
is_qpc = ~is_mse;

% if parameters.plr == 0 
%     parameters.plr = parameters.learningRate;
% end
% qpc_parameters.QPCMethod = 'proto';


beta        = qpc_parameters.beta;
lrate       = qpc_parameters.learningRate;	% learning rate (step of gradnient descent)
% eps         = parameters.eps;	% 
nmax        = qpc_parameters.maxIterations;     % nax. number of iterations
% %lastppi     = -1;
% % ffplot      = 0;
% plotall = 0;
% ninit       = parameters.initiations;
% %ww          = parameters.initWeights;
% dataname    = parameters.dataName;
avgtest     = qpc_parameters.checkPeriod;
stopcriterium = qpc_parameters.stopCriterium;
igmax       = qpc_parameters.indGmax;
wort        = qpc_parameters.ortoWeights;
% lambda      = parameters.lambda;
orto        = ~isempty(wort);
% funcname    = parameters.function;
% %wo          = 0;
% %saveall     = 0;
% %savelast    = 0;
% %savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));
% procedure   = '';
% display     = 0;
% ksi = 0.5;  % procent poprawnych wektorow w klastrze
% 
% %bestw = [];
% %bestppi = [];
% %bestinit = 0;
% %bestn = 0;
% %bestigmax = -1;
% 
% %if ~isempty(parameters.savedir)
% %    savedir = parameters.savedir;
% %end

switch qpc_parameters.display
    case 'all'
        display = 2;
    case 'short'
        display = 1;
    case 'none'
        display = 0;
end
switch qpc_parameters.plot
    case 'all'
        plotall = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% If indGmax not given then compute it here.
if  is_qpc && isempty(igmax)
    [ppi , ~, ~, G] = qpcfunction(x,y,w,[],qpc_parameters.func);
    [~, igmax]=max(G);
end

avgppi = 0;
lastavgppi = 0;
vectorsCount = size(x,1);

if is_qpc 
%    func = @(x,a,b,beta)f_bisigm(x,a,b,beta);
    beta = 1;
    disp('qpcoptimize - dopracowac dobor szrokosci funkcji');
    label = y(igmax);
    t = x(igmax,:)*w';
    dd = beta*0.5;
    a = t - dd;
    b = t + dd;
end

if is_mse
    func = qpc_parameters.function;
    if isempty(parameters.label); error('Labels must be specified for MSE learning'); end
    if isempty(parameters.tresholds); error('Tresholds must be specified for MSE learning'); end
    label = parameters.label;
    a = parameters.tresholds(1);
    if length(parameters.tresholds) == 2;
        b = parameters.tresholds(2);
    else
        b = a;
    end
end
   
n  = 0;
ppitable=zeros(1,nmax);
labelsIndex = (y == label);
positive = sum(labelsIndex);
%labelsPerClassCount = sum(labelsIndex);



while ( 1 )
    if (mod(n,avgtest) == 0 && n > 0)
        lastavgppi = avgppi;
        avgppi = mean(ppitable(n-avgtest+1:n));
  %      beta = beta*1.05;
        lrate = lrate*0.99;
    end;
        
%    w=w/norm(w);
    projection = x*w';

    clind = (projection < b) .* (projection > a);
    nn = sum(clind);
    cl=find(clind);
    ic = find(~(clind .*labelsIndex));
    np = vectorsCount-length(ic);
    if is_qpc
        func = @(x)f_bisigm(x,a,b,beta);
    end

    [ppi dw da db] = clusterfunction(x,y,w,label,func);

    lastppi = ppi;
    ppitable(1,n+1) = ppi;

    if display > 0
        fprintf('%3d  %5.3f [%s ] (%5.3f,%5.3f) +%d/%d -%d/%d %4.1f%%  %4.2f b %.2f l %.4f\n',...
            n,ppi,sprintf(' %5.3f',w),a,b,np,positive,nn-np,...
            vectorsCount-positive,100*np/vectorsCount,np/nn,beta,lrate);
    end
    if plotall == 1
        str=cell(1,3);
        clf;
        set(gcf,'Color','w');
        if orto == 0
            str{1} = strcat('w = ',sprintf(' %.2f ',w));
            str{2} = strcat('I = ',sprintf(' %.5f ',ppitable(n+1)));
            str{3} = strcat('N = ',sprintf(' %d ',n));

          %  ah = bgraph3(projection,y,'position',[0.05 0.4 0.9 0.50],'function',func,'sigma',0.1);
              ah = bgraph(projection,y,'position',[0.05 0.4 0.9 0.50],'function',func,'sigma',0.1,'borders',[a b]);

            axes(ah(1));
            text(0.01,0.95,str,'units','normalized');
        else
            str{2} = strcat('\alpha = ',sprintf(' %.4f ',w1));
            str{1} = strcat('I = ',sprintf(' %.4f ',ppitable(n+1)));
            str{3} = strcat('N = ',sprintf(' %d ',n));

            scaterplot([projection ortoproj],y);

            set(gca,'position',[0.1 0.45 0.85 0.50]);
            xlabel(strcat('w2 = ',sprintf(' %.2f ',w)));
            ylabel(strcat('w1 = ',sprintf(' %.2f ',wort)));

            text(0.02,0.85,str,'units','normalized');
       end
        axes('position',[0.1 0.1 0.85 0.25]);
        plotppi(ppitable,n,50);
        drawnow();
    end;

    if (stopcriterium == 1 && (abs((ppi - lastppi)/lastppi) < eps) && n > 1 ) 
        break;
    end;
    if (stopcriterium == 2 && abs((avgppi - lastavgppi)/lastavgppi) < eps && n > 1 ) 
        break;
    end;
    if ( n >= nmax ) 
        break;
    end

    w = w + lrate * dw;
%        t = t + lrate * dt;
    a = a + lrate * da;
    b = b + lrate * db;
    n = n + 1;

        
end;   % while (1)

node.n = 1;
node.w=w;
node.label = y(igmax);
node.a=a;
node.b=b;
f{1}=func;
node.func=f;
node.np = np;
node.nn = nn;
node.npall = positive;
node.all = vectorsCount;
    
function plotppi(ppitable,n,scalefactor)
    if nargin < 3
        scalefactor = 10;
    end
    if nargin < 2
        n = length(ppitable);
    end
    xl = scalefactor.*(fix(n./scalefactor)+1);
    cla;
    hold on;
    xlim([0 xl]);
    xlabel('Iterations');
    ylabel('PPI value');
    plot(0:n,ppitable(1:n+1),'-b','LineWidth',2);
    box on;
 	hold off;

    
function [parameters unmached]=clusteroptimize_config(varargin)

    param = inputParser;
    param.KeepUnmatched = true;
    param.addOptional('ClusterMethod','mse',@(x)any(strcmpi(x,{'mse','qpc'})));
    param.addOptional('label',[],@(x)isnumeric(x));
    param.addOptional('tresholds',[],@(x)isnumeric(x));
    param.parse(varargin{:});
    parameters = param.Results;
    unmatched = param.Unmatched;
    unames=fieldnames(unmatched);
    clear param;

    if nargout  < 2 && size(unames,1) > 0
            error(['Unknown options: ' sprintf(' "%s"',unames{:})]);
    end
    return;
