function [qpc dqpc projection G]=qpcfunction(x,y,tx,ty,w,ci,func)
%
%  QPC(w)=sum_i sum_j  A_ij* G(w*(x_i-t_j)))
% where A_ij = -1 if class(x) ~= class(t), A_ij = 1 if class(x) == class(t)
%
% CI = class info given by classstat(y)
% QPCFUNCTION computes value of QPC index 
%    Q = QPCFUNCTION(X,Y,W) computes value of QPC index for given dataset
%    X, label table Y and direction W (weights).
%
%    Q = QPCFUNCTION(X,Y,W,FUNC) computes value of QPC index with given function FUNC (function handle, default FUNC=@(x)F_GAUSS(x,0.1)).
%
%    [Q DQ] = QPCFUNCTION(...) returns value of gradient df/dx, the
%    function FUNC must return it's gradient value as a secound output.
%
%    [Q DQ PROJ] = QPCFUNCTION(...) returns value PROJ=X*W' (linear projection on dorection W), for some
%    reasons may be usefull.
%
%   [Q DQ PROJ G] = QPCFUNCTION(...) returns table of values of QPC
%   index partial values for each vector, where G_i = sum_k FUNC( (X_i - X_k)*W')
%   
%Funkcja oblicza wartosc indexsu QPC, dla danych wektorow X oraz etykiet
% klas Y oraz podanego kierunku W i funkcji FUNC.
% Wartosci zwracane: 
%   Q  - wartosc indexu
%   DQ - pochodna funkcji 
%   PROJ - rzyt x*w' - mozna wykozystac w dalszych obliczeniach aby nie
%           powtarzac tej operacji wielokratnie
%   G    - tablica wartosci dla kazdego z wektorow  QPC = 1/A sum G(x)


ninit = size(w,1);

if nargin < 6 || isempty(ci)
    ci=classstat(y);
end

if  nargin < 7 || isempty(func)
    func=@(x)f_gauss(x,0.1);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end

[vectorsCount featuresCount] = size(x);
nt = size(tx,1);


projection = x*w';
tw=tx*w';

G = zeros(ninit,nt);

if nargout > 1
    dqpc =zeros(ninit,featuresCount);
end

for i=1:nt
    ii= ty(i)== ci.labels;
    [f df] = func(projection - ones(vectorsCount,1)*tw(i));
    plus = sum(ci.labelIndex(:,ii)*ones(1,ninit).*f)./ci.labelsCount(ii);
    minus = sum((~ci.labelIndex(:,ii))*ones(1,ninit).*f)./(vectorsCount-ci.labelsCount(ii));
    G(:,i) = plus - minus;
   
     if nargout > 1
         xd = x - ones(vectorsCount,1)*tx(i,:);
         dplus = ((ci.labelIndex(:,ii)*ones(1,ninit).*df)'*xd)./ci.labelsCount(ii);
         dminus = (((~ci.labelIndex(:,ii))*ones(1,ninit).*df)' * xd)./(vectorsCount-ci.labelsCount(ii));
         dqpc = dqpc + dplus - dminus;
     end
end
qpc = sum(G,2)./nt;

if nargout > 1
    dqpc =dqpc./nt;
end
% if lambda ~= 0
%    % tutaj czesc ortonormalizacyjna
%    [fw dfw]=ortof(w,worto,lambda);
%    qpc = qpc  - fw;
%    if nargout > 1
%         dqpc = dqpc - dfw;
%    end
% end
