function scaterplot(x,y,varargin)
% SCATERPLOT plots scatterplot
%
% SCATERPLOT(X,Y) scatterplot of two first dimensions of X with labels Y.
%
% SCATERPLOT(X,Y,FEATURES) scatterplots for all pairs of given FEATURES
% numbers
%
% SCATERPLOT(X,Y,OPTIONS)
%      Options:
%      'color'     : 'yes' or 'no'
%      'features'  : table of features indexes to plot (default [1 2] generate plot for first and secound feature)
%      'labels'    : cell table of string with labels in order acording to apearing in Y table (default 'off' - don't display labels)
%      'featurename' : cell array of features names (default '' - display feature number)
%      'title'     :
%      'str'       : cell of strings, add text to plot
%
%
param = inputParser;

param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);
param.addOptional('features',[1 2],@(x)isnumeric(x));
%param.addParamValue('position',[0.1 0.1 .8 .8],@(x)isnumeric(x) && size(x,2) == 4 );
param.addParamValue('color','yes',@(x)any(strcmpi(x,{'yes','no'})));
param.addParamValue('labels','off');
param.addParamValue('featurename','');
param.addParamValue('title','');
param.addParamValue('str','');
%param.addParamValue('align','left',@(x)any(strcmpi(x,{'left','right'})));

param.parse(x,y,varargin{:});

fig=gcf();
clf;
set(fig,'Renderer','painters');


features=param.Results.features;

color = 1;
if strcmp(param.Results.color,'no')
    color = 0;
end

fname = '';
if ~strcmp(param.Results.featurename,'')
    fname=param.Results.featurename;
else 
    for i=1:length(features)
        fname{i}=sprintf('F%d',features(i));
    end
end

labels=unique(y);
labelsCount=size(labels,1);

set(gcf,'Color','w');

if color == 0
    lw =1;
    ms = 5;
    col = [0 0 0];
else
    col=[1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0.1 0.1 0.1];
    lw = 3;
    ms =3;
end

set(gcf,'DefaultAxesLineStyleOrder','o|+|s|d|^','DefaultAxesColorOrder',col);

labelsInd = cell(1,labelsCount);

for i=1:labelsCount
    labelsInd{i} = find(y == labels(i));
end

n = length(features)-1;
nplot = 1;
for k1=1:n
    f1 = features(k1);
    for k2=k1:n
        f2 = features(k2+1);
        px = cell(1,2*labelsCount);
        subplot(n,n,k1+n*(k2-1));
        cla;
        hold on;
        box on;
        %grid on;
        grid off;

        for i=1:labelsCount
            px{2*i-1} = x(labelsInd{i},f1);
            px{2*i} = x(labelsInd{i},f2);
            ax=gca;
         end
       
        plot(ax,px{:},'LineWidth',lw,'MarkerSize',ms);
        if k2 == n
            xlabel(fname{k1});
        end
        if k1 == 1
            ylabel(fname(k2+1));
        end

        axis equal;
        hold off;
    end
    nplot = nplot +1;
end

if ~strcmp(param.Results.labels,'off')
    labels = param.Results.labels;
    legend(labels)
end


if ~strcmp(param.Results.str,'')
     text(0.05,0.1,param.Results.str,'units','normalized','HorizontalAlignment','left','visible','on');
end
if ~strcmp(param.Results.title,'')
     title(param.Results.title);
end
