function [net trainacc]=ppinetwork(x,y,varargin)
% tworzy siec w oparciu o index PP
%
% TODO
% * dokonczyc opis opcji
% * co robic gdy neuron nie potrafi odeseparowac? Iloczyn neuronow,
% douczanie konfliktowych przypadkow w ortogonalnej przestrzeni
%
% DONE
% * kryterium stopu roznocej sieci - kiedy przestac? (done - zatrzymuje gdy nie rosnie dokladnosc, lub gdy juz nie ma nic do uczenia)

param = inputParser;
% data
param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);

% inner function
param.addOptional('function','f_x4',@(x)any(strcmpi(x,{'triangle','f_x4','fx4','bicentral'})));
param.addOptional('beta',2, @(x)isnumeric(x) && x>0);

% optimalization global
param.addParamValue('learningRate',0.1,@(x)isnumeric(x) && x >= 0);
param.addParamValue('eps',0.001,@(x)isnumeric(x) && x>0);
param.addParamValue('maxIterations',1000,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('initiations',5,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('checkPeriod',5,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('stopCriterium',2,@(x)x==1|| x==2);

% optimalization - case depend
param.addParamValue('initWeights', [],@(x)isnumeric(x));
param.addParamValue('lambda', 0.1,@(x)isnumeric(x) && x > 0 );
param.addParamValue('ortoWeights',[],@isnumeric);
param.addParamValue('indGmax',[],@isnumeric);

% loging
param.addParamValue('logFile',[],@ischar);
param.addParamValue('dataName','data',@ischar);
param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
param.addParamValue('savedir',[],@ischar);
param.addParamValue('display','none',@(x)any(strcmpi(x,{'none','all','short'})));

% plotting
param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));

param.parse(x,y,varargin{:});

%fprintf('Input parameters:\n\n');
%disp(param.Results);
%disp(param.Parameters);


%[vx fx]=size(x);

beta        = param.Results.beta;
lrate       = param.Results.learningRate;	% learning rate (step of gradnient descent)
eps         = param.Results.eps;	% 
nmax        = param.Results.maxIterations;     % nax. number of iterations
%pplot       = 0;
%lastppi     = -1;
% ffplot      = 0;
ninit       = param.Results.initiations;
%ww          = param.Results.initWeights;
%dataname    = param.Results.dataName;
%avgtest     = param.Results.checkPeriod;
%stopcriterium = param.Results.stopCriterium;
%iGmax       = param.Results.indGmax;
%wort        = param.Results.ortoWeights;
%lambda      = param.Results.lambda;
%orto        = ~isempty(wort);
funcname    = param.Results.function;
%wo          = 0;
%saveall     = 0;
%savelast    = 0;
%savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));
%procedure   = '';

ksi = 0.5;  % procent poprawnych wektorow w klastrze

%bestw = [];
%bestppi = [];
%bestinit = 0;
%bestn = 0;
%bestigmax = -1;

%if ~isempty(param.Results.savedir)
%    savedir = param.Results.savedir;
%end
switch param.Results.display
    case 'all'
        display = 2;
    case 'short'
        display = 1;
    case 'none'
        display = 0;
end

k= 1;
learning = 1;

ory = y;
orx = x;

vectorsCount = size(x,1);
[labels a index] = unique(y);
classCount = size(labels,1);
labelIndex = zeros(vectorsCount,classCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0
for i=1:classCount
    labelIndex(:,i) = (index == i);
end
labelsCount=sum(labelIndex);

lasttrainacc = 0;

net = cell(1,1);
while learning
%    fprintf('label '); fprintf('%d',labels); fprintf('\n'); fprintf('count ');fprintf('%d',labelsCount); fprintf('\n');
  %  clf;
    
    [wb ppib ib]=ppoptimize5(x,y,'learningRate',lrate,'initiations',ninit,'eps',eps,'beta',beta,'maxiterations',nmax,'function',funcname,'plot',param.Results.plot,'save',param.Results.save,'display','none');
    
    if display > 1
       fprintf('Best direction: I=%6.3f [%s ]\n',ppib(1),sprintf(' %6.3f',wb(1,:)));
    end
    %    [wb ppib ib]=ppoptimize4(x,y,'learningRate',lrate,'initiations',ninit,'eps',eps,'beta',beta,'maxiterations',nmax,'function',funcname,'plot',param.Results.plot,'save',param.Results.save,'display',param.Results.display);
 %   clf;

    [pc node ic]=clusteroptimize2(x,y,wb(1,:),'indGmax',ib(1));
     
    if (node.np / node.nn) >= ksi
        net{k}=node;
        k = k+ 1;    
        x =x(ic,:); 
        y = y(ic);
        labelIndex=labelIndex(ic,:);
        labelsCount=sum(labelIndex);
        vectorsCount = length(ic);
    else
        %  moze tu dodac neuron datacy jako wyjscie klase wiekszosciowa.
        % lub uczyc inny kierunek  i polaczyc go z poprzednim wynikiem (iloczyn neuronow)
%        break
    end

    currnode = lastnode(x,y);
    currnode.np = labelsCount(labels == currnode.label);
    currnode.nn = vectorsCount;
    currnode.npall = currnode.np;
    currnode.all = vectorsCount;
    
    net{k}=currnode;
 
 %   fprintf('Cuurent network\n');
%    net{:}
    
    currtrainacc=nettest(orx,ory,net);
    
    if display > 0
        fprintf('%2dth node (%d) %4.1f%% %5.3f [%s ] (%6.3f,%6.3f) +%d/%d -%d/%d %4.1f%%  %4.2f\n',k-1,node.label,currtrainacc,pc,sprintf(' %6.3f',node.w),node.a,node.b,node.np,node.npall,node.nn-node.np,node.all-node.npall,100*node.np/node.all,node.np/node.nn);
    end
    % fprintf('Adding %dth node, accuracy %f \n',k-1,currtrainacc);
    
    if sum(labelsCount > 0) == 1
        break
    end

    if currtrainacc <= lasttrainacc
        net{k-1} = lnode;
        net=net(1:k-1);
%        fprintf('Removing bad neuron\n')
        break
    end
    lnode = currnode;
    lasttrainacc = currtrainacc;
end

trainacc=nettest(orx,ory,net);
%fprintf('Koncowa siec\n'); 
%net{:}

if display > 0
    fprintf(' Train acc. %6.2f\n',trainacc);
end

function node=lastnode(x,y)
        node.w=zeros(1,size(x,2));
        node.label = mode(y);
        node.a=-1;
        node.b=1;
        node.func=@(x)ones(size(x,1),1);
