function [ppi dppi]=ppi2wfunction2(x,y,w,lambda,func)
% two directions w=[w1 w2] at once

if nargin < 4
    lambda = 1;
end
if nargin < 5
    func=@(x)f_x4(x,2);
end
[vc fc]=size(x);
if (length(w) ~= fc*2)
    error('Error: w != [w1 w2]');
end

w1 = w(1:fc);
w2 = w(fc+1:end);
[ppi1 dppi1]=ppifunction(x,y,w1,func,w2,lambda);
[ppi2 dppi2]=ppifunction(x,y,w2,func,w1,lambda);

ppi = ppi1 + ppi2;
dppi = [dppi1 dppi2];  
