function [ppi node ic] = clusteroptimize2(x,y,w,varargin)
% PPIGMAXFUNCTION computes value of PPIndex for given vector X(I).
%
%    PPI = CLUSTERFIND(X,Y,W,B,FUNC) looking for best PPI value in respect to W and T,
%            where T is a center of cluster, initially T=X(I) and T is
%            associated with class Y(I)
%
%%


param = inputParser;
% data
param.addRequired('x',@isnumeric);
param.addRequired('y',@isnumeric);
param.addRequired('w',@isnumeric);

% inner function
param.addOptional('function','f_x4',@(x)any(strcmpi(x,{'triangle','f_x4','fx4','bicentral'})));
param.addOptional('beta',2, @(x)isnumeric(x) && x>0);

% optimalization global
param.addParamValue('learningRate',0.1,@(x)isnumeric(x) && x >= 0);
param.addParamValue('eps',0.001,@(x)isnumeric(x) && x>0);
param.addParamValue('maxIterations',100,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('initiations',5,@(x)isnumeric(x) && x > 0 && mod(x,1)==0);
param.addParamValue('checkPeriod',5,@(x)isnumeric(x) && x>0 && mod(x,1)==0);
param.addParamValue('stopCriterium',2,@(x)x==1|| x==2);

% optimalization - case depend
%param.addParamValue('initWeights', [],@(x)isnumeric(x));
param.addParamValue('lambda', 0.1,@(x)isnumeric(x) && x > 0 );
param.addParamValue('ortoWeights',[],@isnumeric);
param.addParamValue('indGmax',[],@isnumeric);

% loging
param.addParamValue('logFile',[],@ischar);
param.addParamValue('dataName','data',@ischar);
param.addParamValue('save','none',@(x)any(strcmpi(x,{'none','all','last'})));
param.addParamValue('savedir',[],@ischar);
param.addParamValue('display','none',@(x)any(strcmpi(x,{'none','all','short'})));

% plotting
param.addParamValue('plot','none',@(x)any(strcmpi(x,{'none','all','ppi','last'})));

param.parse(x,y,w,varargin{:});

%fprintf('Input parameters:\n\n');
%disp(param.Results);
%disp(param.Parameters);


%[vx fx]=size(x);

beta        = param.Results.beta;
lrate       = param.Results.learningRate;	% learning rate (step of gradnient descent)
eps         = param.Results.eps;	% 
nmax        = param.Results.maxIterations;     % nax. number of iterations
iplot       = 0;
%lastppi     = -1;
% ffplot      = 0;
plotall = 0;
ninit       = param.Results.initiations;
%ww          = param.Results.initWeights;
dataname    = param.Results.dataName;
avgtest     = param.Results.checkPeriod;
stopcriterium = param.Results.stopCriterium;
igmax       = param.Results.indGmax;
wort        = param.Results.ortoWeights;
lambda      = param.Results.lambda;
orto        = ~isempty(wort);
funcname    = param.Results.function;
%wo          = 0;
%saveall     = 0;
%savelast    = 0;
%savedir     = strcat('ppi-results-',datestr(now,'yyyy.mm.dd'));
procedure   = '';
display     = 0;
ksi = 0.5;  % procent poprawnych wektorow w klastrze

%bestw = [];
%bestppi = [];
%bestinit = 0;
%bestn = 0;
%bestigmax = -1;

%if ~isempty(param.Results.savedir)
%    savedir = param.Results.savedir;
%end

switch param.Results.display
    case 'all'
        display = 2;
    case 'short'
        display = 1;
    case 'none'
        display = 0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if ( nargin < 3 )
    error('Za malo argumentow');
end

func=@(x)f_x4(x,beta);

if  isempty(igmax)
    [ppi projection G] = ppifunction(x,y,w,func);
    [Gmax igmax]=max(G);
    %t = x(:,igmax)*w';
    %b = [t-1 t+1];
end

avgppi = 0;
%avgtest = 5;
lastavgppi = 0;
be = beta;

labelIndex = (y == y(igmax));
positive = sum(labelIndex);
%labelsCount = sum(labelIndex);

vectorsCount = size(x,1);

n  = 0;
t = x(igmax,:)*w';
a = t - 1;
b = t + 1;
ppitable=zeros(1,nmax);

    while ( 1 )

        func = @(x)f_bisigm(x,a,b,be);
        
        if (mod(n,avgtest) == 0 && n > 0)
            lastavgppi = avgppi;
            avgppi = mean(ppitable(n-avgtest+1:n));
            be = be*1.1;
            lrate = lrate*0.95;
        end;
        
        w=w/norm(w);
        projection = x*w';
        
        clind = (projection < b) .* (projection > a);
        nn = sum(clind);
        ic = find(~(clind .*labelIndex));
        np = vectorsCount-length(ic);
        
        [ppi dw da db] = clusterfunction2(x,y,w,igmax,func);
		
        lastppi = ppi;
		ppitable(1,n+1) = ppi;
	
       if iplot == 1 && n > 0
			plotppi(ppitable,n,avgtest);
            drawnow;
        end
        if display > 0
            fprintf('%3d  %5.3f [%s ] (%5.3f,%5.3f) +%d/%d -%d/%d %4.1f%%  %4.2f\n',n,ppi,sprintf(' %5.3f',w),a,b,np,positive,nn-np,vectorsCount-positive,100*np/vectorsCount,np/nn);
        end
        if plotall == 1
            str=cell(1,3);
            clf;
            set(gcf,'Color','w');
            if orto == 0
                
                str{1} = strcat('w = ',sprintf(' %.2f ',w));
                str{2} = strcat('I = ',sprintf(' %.5f ',ppitable(n+1)));
                str{3} = strcat('N = ',sprintf(' %d ',n));
 
                ah = bgraph3(projection,y,'position',[0.05 0.4 0.9 0.50],'function',func,'sigma',0.1);

                axes(ah(1));
                text(0.01,0.95,str,'units','normalized');

%                plot(projection,np,'o');
            else
                str{2} = strcat('\alpha = ',sprintf(' %.4f ',w1));
                str{1} = strcat('I = ',sprintf(' %.4f ',ppitable(n+1)));
                str{3} = strcat('N = ',sprintf(' %d ',n));
                
                
                scaterplot([projection ortoproj],y);
                
                set(gca,'position',[0.1 0.45 0.85 0.50]);
                xlabel(strcat('w2 = ',sprintf(' %.2f ',w)));
                ylabel(strcat('w1 = ',sprintf(' %.2f ',wort)));
                
                text(0.02,0.85,str,'units','normalized');

            end
            axes('position',[0.1 0.1 0.85 0.25]);
            plotppi(ppitable,n,50);
            drawnow();
            
            
        end;
        

        if (stopcriterium == 1 && (abs((ppi - lastppi)/lastppi) < eps) && n > 1 ) 
            break;
        end;
        if (stopcriterium == 2 && abs((avgppi - lastavgppi)/lastavgppi) < eps && n > 1 ) 
            break;
        end;
        if ( n >= nmax ) 
            break;
        end
        
        w = w + lrate * dw;
%        t = t + lrate * dt;
        a = a + lrate * da;
        b = b + lrate * db;
        n = n + 1;

        
    end;

    node.w=w;
    node.label = y(igmax);
    node.a=a;
    node.b=b;
    node.func=func;
    node.np = np;
    node.nn = nn;
    node.npall = positive;
    node.all = vectorsCount;
    
    function plotppi(ppitable,n,scalefactor)
    if nargin < 3
        scalefactor = 10;
    end
    if nargin < 2
        n = length(ppitable);
    end
    xl = scalefactor.*(fix(n./scalefactor)+1);
    cla;
    hold on;
    xlim([0 xl]);
    xlabel('Iterations');
    ylabel('PPI value');
    plot(0:n,ppitable(1:n+1),'-b','LineWidth',2);
    box on;
 	hold off;
