function [ppi dppi daa dbb np nn] = clusterfunction2(x,y,w,igmax,func,a,b)
% CLUSTERFUNCTION computes value of PPIndex for given vector X(I).
%  UWAGA - opis nie aktualny
%
%    PPI = CLUSTERFUNCTION(X,Y,W,t) value of PPI for in respect to W and T,
%            where T is a center of cluster associated with class Y(I)
%
%    PPI = CLUSTERFUNCTION(X,Y,W,I,T,FUNC) 
%    PPI = CLUSTERFUNCTION(X,Y,W,I,T,FUNC,BETA) 
%
%    [PPI DPPI] = CLUSTERFUNCTION(...) 
%
%    [PPI DPPI DCENTER] = CLUSTERFUNCTION(...) 
%%


if  nargin < 4
    func=@(x)f_x4(x,2);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end


[vectorsCount featuresCount] = size(x);

labelIndex = (y == y(igmax));
labelsCount=sum(labelIndex);

Ap = labelsCount;
An = (vectorsCount-labelsCount);

projection = x*w';
%nn = (projection <= a 

if nargout > 1
    dppi =zeros(1,featuresCount);
end
%t = projection(igmax);

[f df da db] = func(projection);

plus = sum(labelIndex.*f)./Ap;
minus = sum((~labelIndex).*f)./An;
ppi = plus - minus;

daplus =0;
daminus = 0;
dbplus = 0;
dbminus = 0;

if nargout > 1
%    xd = x - t;
    xd = x;
    
    dplus = ((labelIndex.*df)'*xd)./Ap;
    dminus = (((~labelIndex).*df)' * xd)./An;
    dppi = dplus - dminus;
    
    
    daplus = (labelIndex'*da)./Ap;
    daminus = (~labelIndex'*da)./An;
    dbplus = (labelIndex'*db)./Ap;
    dbminus = (~labelIndex'*db)./An;
    
    daa = daplus - daminus;
    dbb = dbplus - dbminus;
    
%     dtplus = - ((labelIndex.*df)'*(ones(vectorsCount,1)*w))./Ap;
%     dtminus = - (((~labelIndex).*df)' * (ones(vectorsCount,1)*w))./An;
% 
%     dt = dtplus - dtminus;
end
