﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.IO;
using System.Threading;

namespace KS
{
    public class Receive
    {
        public static string ReceiveUntilStop(UdpClient c)
        {
            String strData = "";
            String Ret = "";
            ASCIIEncoding ASCII = new ASCIIEncoding();

            IPEndPoint endpoint = new IPEndPoint(IPAddress.IPv6Any, 50);

            while (!strData.Equals("Over"))
            {
                Byte[] data = c.Receive(ref endpoint);
                strData = ASCII.GetString(data);
                Ret += strData + "\n";
            }
            return Ret;
        }
    }

    public class Send
    {
        private static string greetings = "Hello Target.";
        private static string nice = "Have a nice day.";
        private static string eom = "Over";
        private static string tGreetings = "Hello Originator!";
        private static string tNice = "You too.";

        public static void OriginatorSendData(UdpClient c, IPEndPoint ep)
        {
            Console.WriteLine(greetings);
            c.Send(GetByteArray(greetings.ToCharArray()), greetings.Length, ep);
            Thread.Sleep(1000);

            Console.WriteLine(nice);
            c.Send(GetByteArray(nice.ToCharArray()), nice.Length, ep);

            Thread.Sleep(1000);
            Console.WriteLine(eom);
            c.Send(GetByteArray(eom.ToCharArray()), eom.Length, ep);
        }

        public static void TargetSendData(UdpClient c, IPEndPoint ep)
        {
            Console.WriteLine(tGreetings);
            c.Send(GetByteArray(tGreetings.ToCharArray()), tGreetings.Length, ep);
            Thread.Sleep(1000);

            Console.WriteLine(tNice);
            c.Send(GetByteArray(tNice.ToCharArray()), tNice.Length, ep);

            Thread.Sleep(1000);
            Console.WriteLine(eom);
            c.Send(GetByteArray(eom.ToCharArray()), eom.Length, ep);
        }
        private static Byte[] GetByteArray(Char[] ChArray)
        {
            Byte[] Ret = new Byte[ChArray.Length];
            for (int i = 0; i < ChArray.Length; i++)
                Ret[i] = (Byte)ChArray[i];
            return Ret;
        }
    }


    public class ClientTarget
    {
        private static UdpClient m_ClientTarget;
        private static IPAddress m_GrpAddr;

        public static void MainTarget()
        {
            string Ret;

            m_ClientTarget = new UdpClient(1000, AddressFamily.InterNetworkV6);
            //m_ClientTarget = new UdpClient(1000, AddressFamily.InterNetwork);
            m_GrpAddr = IPAddress.Parse("FF01::1");
            //m_GrpAddr = IPAddress.Parse("224.0.0.12");

            m_ClientTarget.JoinMulticastGroup(m_GrpAddr);

            IPEndPoint ClientOriginatordest = new IPEndPoint(m_GrpAddr, 2000);

            Ret = Receive.ReceiveUntilStop(m_ClientTarget);
            Console.WriteLine("\nThe ClientTarget received: " + "\n\n" + Ret + "\n");

            Thread.Sleep(2000);

            Console.WriteLine("\nThe ClientTarget sent:\n");
            Send.TargetSendData(m_ClientTarget, ClientOriginatordest);

            m_ClientTarget.DropMulticastGroup(m_GrpAddr);
        }
    }


    public class ClientOriginator
    {
        private static UdpClient clientOriginator;
        private static IPAddress m_GrpAddr;
        private static IPEndPoint m_ClientTargetDest;

        public static bool MainOriginator()
        {
            try
            {
                clientOriginator = new UdpClient(2000, AddressFamily.InterNetworkV6);
                //clientOriginator = new UdpClient(2000, AddressFamily.InterNetwork);
                m_GrpAddr = IPAddress.Parse("FF01::1");
                //m_GrpAddr = IPAddress.Parse("224.0.0.12");

                clientOriginator.JoinMulticastGroup(m_GrpAddr);

                m_ClientTargetDest = new IPEndPoint(m_GrpAddr, 1000);

                Thread.Sleep(2000);

                SendAndReceive();

                return true;
            }
            catch (Exception e)
            {
                Console.WriteLine("[ClientOriginator.ConnectClients] Exception: " + e.ToString());
                return false;
            }
        }

        public static string SendAndReceive()
        {
            string Ret = "";

            Console.WriteLine("\nThe ClientOriginator sent:\n");
            Send.OriginatorSendData(clientOriginator, m_ClientTargetDest);

            Ret = Receive.ReceiveUntilStop(clientOriginator);

            clientOriginator.DropMulticastGroup(m_GrpAddr);

            Console.WriteLine("\nThe ClientOriginator received: " + "\n\n" + Ret);

            return Ret;
        }
    }
}
