﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Threading;

namespace KS
{
    public class UDP
    {
        public static void KlientUDP(string[] args)
        {
            int port1 = args.Length > 0 ? int.Parse(args[0]) : 11000;
            int port2 = args.Length > 1 ? int.Parse(args[1]) : 11001;

            KlientUDP(port1, port2);
        }

        public static void KlientUDP(int portLokalny, int portZdalny)
        {
            System.Threading.Thread.Sleep(3000); // daj czas serwerowi na start

            UdpClient udpClient = new UdpClient(portLokalny);
            try
            {
                Byte[] sendBytes = Encoding.ASCII.GetBytes("Is anybody there?" + Śmieci(65000) + ". Koniec!");
                
                udpClient.Connect("localhost", portZdalny);
                udpClient.Send(sendBytes, sendBytes.Length);

                IPEndPoint RemoteIpEndPoint = new IPEndPoint(IPAddress.Any, 0);
                Byte[] receiveBytes = udpClient.Receive(ref RemoteIpEndPoint);
                string returnData = Encoding.ASCII.GetString(receiveBytes);

                Console.WriteLine("This is the message you received {0}", returnData);
                Console.WriteLine("This message was sent from {0}:{1}", RemoteIpEndPoint.Address, RemoteIpEndPoint.Port);

                udpClient.Close();
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        public static void ServerUDP(int portLokalny=11001)
        {
            UdpClient udpClient = new UdpClient(portLokalny);
            try
            {
                string greeting = "Witam! Tu serwer!";
                Byte[] sendBytes = Encoding.ASCII.GetBytes(greeting);

                while (true)
                {
                    IPEndPoint RemoteIpEndPoint = new IPEndPoint(IPAddress.Any, 0);
                    Byte[] receiveBytes = udpClient.Receive(ref RemoteIpEndPoint);
                    string returnData = Encoding.ASCII.GetString(receiveBytes);

                    Console.WriteLine("Received {0} from {1}, port {2}", returnData,
                        RemoteIpEndPoint.Address, RemoteIpEndPoint.Port);

                    udpClient.Send(sendBytes, sendBytes.Length, RemoteIpEndPoint);
                    Console.WriteLine("Sent to {0}:{1}: {2}", RemoteIpEndPoint.Address, RemoteIpEndPoint.Port, greeting);

                    break;
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
            udpClient.Close();
        }

        private static string Śmieci(int ile)
        {
            Random r = new Random();
            char[] tab = new char[ile];
            for (int i = 0; i < ile; i++)
                tab[i] = (char)r.Next(48, 122);
            return new string(tab);
        }
    }
}
