#include "Gra.h"
#include "Gracz.h"

Gra::Gra(int liczbaw, int liczbak, Gracz *gracz1, Gracz *gracz2)
	: gracz1(gracz1), gracz2(gracz2), kolej1(true),
	  liczbaW(liczbaw), liczbaK(liczbak)
{
	//this->gracz1 = gracz1;
	//Gra::gracz1 = gracz1;
	plansza = new char* [liczbaW];
	for (int i = 0; i < liczbaW; i++)
	{
		plansza[i] = new char[liczbaK];
		for (int j = 0; j < liczbaK; j++)
			plansza[i][j] = PUSTO;
	}
}

Gra::~Gra()
{
	for (int i = 0; i < liczbaW; i++)
		delete[] plansza[i];
	delete[] plansza;
}

void Gra::Krok()
{
	int wiersz, kolumna;
	if (kolej1)
		gracz1->Ruch(this, wiersz, kolumna);
	else
		gracz2->Ruch(this, wiersz, kolumna);
	plansza[wiersz][kolumna] = kolej1 ? 'o' : 'x';
	kolej1 = !kolej1;
}

bool Gra::Linia(int w, int k, int dw, int dk)
{
	char znak = plansza[w][k];
	if (znak == PUSTO)
		return false;
	do
	{
		w += dw;
		k += dk;
		if (w < 0 || w >= liczbaW || k < 0 || k >= liczbaK)
			return true;
		if (plansza[w][k] != znak)
			return false;
	} while (true);
}


bool Gra::Koniec()
{
	for (int i = 0; i < liczbaW; i++)
		if (Linia(i, 0, 0, 1))
			return true;
	for (int i = 0; i < liczbaK; i++)
		if (Linia(0, i, 1, 0))
			return true;
	if (Linia(0, 0, 1, 1))
		return true;
	if (Linia(0, liczbaK - 1, 1, -1))
		return true;
	for (int i = 0; i < liczbaW; i++)
		for (int j = 0; j < liczbaK; j++)
			if (plansza[i][j] == PUSTO)
				return false;
	return true;
}

